/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFilter {
    private static final Logger log = LoggerFactory.getLogger(MapFilter.class);
    private Map<String, Object> filterMap;

    public void setFilterMap(Map<String, Object> filterMap) {
        this.filterMap = filterMap;
    }

    public boolean filter(Map<String, Object> filteredMap) {
        boolean pass = true;
        if (this.filterMap != null) {
            block4: for (String key : this.filterMap.keySet()) {
                Object oFilterVal = this.filterMap.get(key);
                Object oCandVal = filteredMap.get(key);
                try {
                    if (oFilterVal instanceof String) {
                        String filterVal = (String)oFilterVal;
                        String candVal = (String)oCandVal;
                        if (!StringUtils.isEmpty((String)candVal) && candVal.toUpperCase().contains(filterVal.toUpperCase())) continue;
                        pass = false;
                        break;
                    }
                    if (oFilterVal instanceof JSONObject) {
                        JSONObject jsonFilterDef = (JSONObject)oFilterVal;
                        try {
                            String type = jsonFilterDef.getString("type");
                            if ("listmember".equals(type)) {
                                String searchedKey = jsonFilterDef.optString("key");
                                String searchedVal = jsonFilterDef.getString("value");
                                pass = false;
                                if (oCandVal == null) continue;
                                JSONArray array = (JSONArray)oCandVal;
                                String searchedValUpper = searchedVal.toUpperCase();
                                for (int i = 0; i < array.length(); ++i) {
                                    String memberVal;
                                    Object listMember = array.get(i);
                                    if (listMember instanceof String) {
                                        String listMemberString = (String)listMember;
                                        if (!listMemberString.toUpperCase().contains(searchedValUpper)) continue;
                                        pass = true;
                                        continue block4;
                                    }
                                    if (!(listMember instanceof JSONObject) || (memberVal = ((JSONObject)listMember).optString(searchedKey)) == null || !memberVal.toUpperCase().contains(searchedValUpper)) continue;
                                    pass = true;
                                    continue block4;
                                }
                                continue;
                            }
                            throw new RuntimeException("Unknown filtering type: " + type);
                        }
                        catch (JSONException je) {
                            throw new RuntimeException("Problem with json filter definition '" + jsonFilterDef + "'.", je);
                        }
                    }
                    if (oFilterVal == null) continue;
                    log.error("Unknown filter value type: " + oFilterVal.getClass() + " val: '" + oFilterVal.toString() + "'. Ignored.");
                }
                catch (ClassCastException cce) {
                    log.error("Cannot filter {} with filter type {}, values: {}, {}", (Object[])new String[]{oCandVal == null ? "null" : oCandVal.getClass().toString(), oFilterVal.getClass().toString(), oCandVal == null ? "null" : oCandVal.toString(), oFilterVal == null ? "null" : oFilterVal.toString()});
                }
            }
        }
        return pass;
    }

    public int ingestJson(String filterParam) throws JSONException {
        int retval = 0;
        if (!StringUtils.isEmpty((String)filterParam)) {
            JSONObject filterJsonData = new JSONObject(filterParam);
            Iterator<String> keys = filterJsonData.keys();
            if (keys.hasNext() && this.filterMap == null) {
                this.filterMap = new HashMap<String, Object>();
            }
            while (keys.hasNext()) {
                String key = keys.next();
                Object value = filterJsonData.get(key);
                this.filterMap.put(key, value);
                ++retval;
            }
        }
        return retval;
    }

    public String toString() {
        return "MapFilter with filter: {" + this.filterMap + "}";
    }
}

