/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.parser.taghandlers.mbox;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.mcm.landingpage.parser.taghandlers.mbox.MBoxExperienceTagHandler;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.ContainerComponentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class TargetComponentTagHandler
extends AbstractTagHandler
implements EventHandler,
ContainerComponentProvider {
    private String suffix;
    private Map<String, List<PageComponent>> experiences = new HashMap<String, List<PageComponent>>();
    private ServiceRegistration serviceRegistration;
    private Logger logger = LoggerFactory.getLogger(TargetComponentTagHandler.class);
    private String resourceType;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException, UnsupportedTagContentException {
        super.startElement(uri, localName, qName, atts);
        if (!(this.delegate instanceof MBoxExperienceTagHandler)) {
            throw new UnsupportedTagContentException("Target component tag must only contain MBox experience tags");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        super.characters(ch, start, length);
        if (this.delegate == null && new String(ch, start, length).trim().length() > 0) {
            throw new UnsupportedTagContentException("Illicit HTML content encountered. Target component tag must only contain MBox experience tags.");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        String experience;
        TagHandler lastDelegate = this.delegate;
        super.endElement(uri, localName, qName);
        if (this.delegate == null && lastDelegate instanceof MBoxExperienceTagHandler && !((MBoxExperienceTagHandler)lastDelegate).isDefaultExperience() && (experience = ((MBoxExperienceTagHandler)lastDelegate).getSegment()) != null) {
            List<PageComponent> offerComponents = ((MBoxExperienceTagHandler)lastDelegate).getOfferComponents();
            this.experiences.put(experience, offerComponents);
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix("mbox");
        HashMap<String, Object> base = new HashMap<String, Object>();
        ValueMapDecorator properties = new ValueMapDecorator(base);
        properties.put("nameHint", this.getNameHint());
        PageComponent mbox = this.pageBuilder.createComponent(this.resourceType, properties, this.getNameHint());
        if (this.pageComponents.size() <= 0) {
            throw new UnsupportedTagContentException("No default experience component tag found. The mbox component tag must contain exactly one default experience component tag");
        }
        if (this.pageComponents.size() > 1) {
            throw new UnsupportedTagContentException("Multiple experience component tags found. The mbox component tag must contain exactly one default experience component tag");
        }
        PageComponent component = (PageComponent)this.pageComponents.get(0);
        PageComponent defaultComponent = this.pageBuilder.createComponent(component.getResourceType(), component.getProperties(), "default");
        defaultComponent.getChildComponents().addAll(component.getChildComponents());
        mbox.getChildComponents().add(defaultComponent);
        this.pageComponents = new ArrayList();
        this.pageComponents.add(mbox);
        String[] topics = new String[]{"com/day/cq/wcm/designimporter/CanvasPageBuilder/COMPLETE"};
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("event.topics", topics);
        if (this.designImporterContext.bundleContext != null) {
            this.serviceRegistration = this.designImporterContext.bundleContext.registerService(EventHandler.class.getName(), (Object)this, props);
        }
    }

    private String getNameHint() {
        return "mbox" + this.suffix;
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(this.componentDivStartTag);
        }
        return null;
    }

    private BundleContext getBundleContext() {
        return this.designImporterContext.bundleContext;
    }

    public void handleEvent(Event event) {
        ServiceReference ref = this.getBundleContext().getServiceReference(QueryBuilder.class.getName());
        QueryBuilder queryBuilder = (QueryBuilder)this.getBundleContext().getService(ref);
        Query query = null;
        String mboxComponentPath = null;
        String mboxComponentName = "";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", this.designImporterContext.page.getPath());
            map.put("property", "nameHint");
            map.put("property.value", this.getNameHint());
            query = queryBuilder.createQuery(PredicateGroup.create(map), this.designImporterContext.designNode.getSession());
            SearchResult result = query.getResult();
            for (Hit hit : result.getHits()) {
                mboxComponentPath = hit.getPath();
                mboxComponentName = mboxComponentPath.replaceFirst(".*/", "");
            }
            for (Map.Entry entry : this.experiences.entrySet()) {
                String experience = (String)entry.getKey();
                ArrayList<PageComponent> components = (ArrayList<PageComponent>)entry.getValue();
                this.createExperienceIfNotExists(this.designImporterContext.page.getParent(), experience);
                HashMap<String, Object> base = new HashMap<String, Object>();
                ValueMapDecorator properties = new ValueMapDecorator(base);
                PageComponent parsys = this.pageBuilder.createComponent("foundation/components/parsys", properties, "par");
                parsys.getChildComponents().addAll((Collection<PageComponent>)components);
                components = new ArrayList<PageComponent>();
                components.add(parsys);
                String pageRoot = this.designImporterContext.page.getParent().getPath() + "/" + experience;
                String pageName = this.designImporterContext.page.getPath().replaceFirst(".*/", "") + "_" + mboxComponentName;
                String pageTemplate = null;
                Page page = this.pageBuilder.createPage(pageRoot, pageName, null, pageTemplate, null, components);
                JcrUtil.setProperty(page.getContentResource().adaptTo(Node.class), "location", mboxComponentPath);
                JcrUtil.setProperty(page.getContentResource().adaptTo(Node.class), "sling:resourceType", "cq/personalization/components/teaserpage");
                JcrUtil.setProperty(page.getContentResource().adaptTo(Node.class), "jcr:title", page.getParent().getTitle());
            }
        }
        catch (WCMException e) {
            this.logger.error("An exception occurred trying to create the offer page", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.logger.error("An exception occurred trying to create the offer page", (Throwable)e);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    private void createExperienceIfNotExists(Page parent, String experience) throws RepositoryException, WCMException {
        if (parent.adaptTo(Node.class).hasNode(experience)) {
            return;
        }
        String pageRoot = parent.getPath();
        String pageName = experience;
        String pageTemplate = "/libs/cq/personalization/templates/experience";
        Page page = this.pageBuilder.createPage(pageRoot, pageName, null, pageTemplate, null, new ArrayList<PageComponent>());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", "/etc/segmentation");
        map.put("nodename", experience);
        map.put("property", "jcr:content/sling:resourceType");
        map.put("property.value", "cq/personalization/components/segmentpage");
        ServiceReference ref = this.getBundleContext().getServiceReference(QueryBuilder.class.getName());
        QueryBuilder queryBuilder = (QueryBuilder)this.getBundleContext().getService(ref);
        Query query = queryBuilder.createQuery(PredicateGroup.create(map), this.designImporterContext.designNode.getSession());
        SearchResult result = query.getResult();
        ArrayList<String> segments = new ArrayList<String>();
        String experienceTitle = experience;
        for (Hit hit : result.getHits()) {
            Node contentNode;
            String segmentPath = hit.getPath();
            segments.add(segmentPath);
            if (experienceTitle != experience || !(contentNode = hit.getNode().getNode("jcr:content")).hasProperty("jcr:title")) continue;
            experienceTitle = contentNode.getProperty("jcr:title").getString();
        }
        if (segments.size() == 0) {
            this.designImporterContext.importWarnings.add("Segment " + experience + " not found. The target component might not work as expected.");
            this.logger.warn("Segment " + experience + " not found. The target component might not work as expected.");
        }
        JcrUtil.setProperty(page.getContentResource().adaptTo(Node.class), "cq:segments", segments.toArray(new String[0]));
        JcrUtil.setProperty(page.getContentResource().adaptTo(Node.class), "jcr:title", experienceTitle);
    }

    public void setResourcetype(String resourceType) {
        this.resourceType = resourceType;
    }
}

