/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"cq/personalization/touch-ui/datasource/segmentsdatasource"})
public class SegmentsDataSourceServlet
extends SlingSafeMethodsServlet {
    private static final String SEGMENT_RESOURCE_TYPE = "cq/personalization/components/segmentpage";
    private static final String SEGMENTATION_ROOT = "/etc/segmentation";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ArrayList<ValueMapResource> resourceList = new ArrayList<ValueMapResource>();
        ResourceResolver resolver = request.getResourceResolver();
        Resource root = resolver.getResource(SEGMENTATION_ROOT);
        SegmentsRetriever visitor = new SegmentsRetriever();
        visitor.accept(root);
        List<JSONObject> segments = visitor.getSegments();
        Collections.sort(segments, new SegmentsComparator());
        try {
            for (JSONObject segment : segments) {
                HashMap<String, Object> segmentEntry = new HashMap<String, Object>();
                segmentEntry.put("value", segment.get("path"));
                segmentEntry.put("text", segment.get("title"));
                ValueMapResource vmRes = new ValueMapResource(resolver, new ResourceMetadata(), "", (ValueMap)new ValueMapDecorator(segmentEntry));
                resourceList.add(vmRes);
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        request.setAttribute(DataSource.class.getName(), new SimpleDataSource(resourceList.iterator()));
    }

    class SegmentsComparator
    implements Comparator<JSONObject> {
        SegmentsComparator() {
        }

        @Override
        public int compare(JSONObject o1, JSONObject o2) {
            if (!o1.has("title") || !o2.has("title")) {
                return -1;
            }
            try {
                String o1Title = (String)o1.get("title");
                String o2Title = (String)o2.get("title");
                return o1Title.compareTo(o2Title);
            }
            catch (Exception e) {
                SegmentsDataSourceServlet.this.log.error(e.getMessage(), (Throwable)e);
                return -1;
            }
        }
    }

    class SegmentsRetriever
    extends AbstractResourceVisitor {
        private List<JSONObject> segments = new ArrayList<JSONObject>();

        SegmentsRetriever() {
        }

        @Override
        protected void visit(Resource resource) {
            if (SegmentsDataSourceServlet.SEGMENT_RESOURCE_TYPE.equals(resource.getResourceType())) {
                Resource parentPage = resource.getParent();
                ValueMap vm = resource.adaptTo(ValueMap.class);
                JSONObject object = new JSONObject();
                String title = vm.get("jcr:title", "") + (this.hasTargetTrait(resource) ? " (from Adobe Target)" : "");
                try {
                    object.put("title", title);
                    object.put("name", parentPage.getName());
                    object.put("path", parentPage.getPath());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.segments.add(object);
            }
        }

        private boolean hasTargetTrait(Resource res) {
            if ("cq/personalization/components/traits/tandt".equals(res.getResourceType())) {
                return true;
            }
            Iterator<Resource> resourceIterator = res.listChildren();
            if (resourceIterator.hasNext()) {
                Resource currentResource = resourceIterator.next();
                return this.hasTargetTrait(currentResource);
            }
            return false;
        }

        public List<JSONObject> getSegments() {
            return this.segments;
        }
    }
}

