/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.reporting;

import com.day.cq.reporting.Aggregate;
import com.day.cq.reporting.Column;
import com.day.cq.reporting.ComponentProvider;
import com.day.cq.reporting.Context;
import java.util.HashMap;
import java.util.Map;

public class AggregateManager {
    private final ComponentProvider componentService;
    protected Map<Column, Aggregate> aggregatePerColumn;

    public AggregateManager(Context context) {
        this.componentService = context != null ? context.getComponentService() : null;
        this.aggregatePerColumn = new HashMap<Column, Aggregate>(16);
    }

    private Aggregate createAggregateFromType(String type) {
        Aggregate aggregate = this.componentService.acquireAggregate(type);
        if (aggregate == null) {
            throw new IllegalArgumentException("Aggregate type '" + type + "' is not " + "supported by this implementation.");
        }
        return aggregate;
    }

    public void createForColumn(Column col) {
        String type = col.getAggregateType();
        if (type != null) {
            Aggregate existingAggregate = this.aggregatePerColumn.get(col);
            if (existingAggregate != null) {
                this.componentService.releaseAggregate(existingAggregate);
            }
            this.aggregatePerColumn.put(col, this.createAggregateFromType(type));
        }
    }

    public Aggregate getForColumn(Column col) {
        return this.aggregatePerColumn.get(col);
    }

    public void cleanup() {
        for (Column col : this.aggregatePerColumn.keySet()) {
            Aggregate aggregateToRelease = this.aggregatePerColumn.get(col);
            this.componentService.releaseAggregate(aggregateToRelease);
        }
        this.aggregatePerColumn.clear();
    }
}

