/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search;

import com.day.cq.search.PredicateGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Predicate
implements Cloneable {
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_EXCERPT = "excerpt";
    public static final String PARAM_GUESS_TOTAL = "guessTotal";
    public static final String ORDER_BY = "orderby";
    public static final String PARAM_SORT = "sort";
    public static final String SORT_ASCENDING = "asc";
    public static final String SORT_DESCENDING = "desc";
    public static final String PARAM_CASE = "case";
    public static final String IGNORE_CASE = "ignore";
    private final String type;
    private String name;
    private PredicateGroup parent;
    private Map<String, String> params = new HashMap<String, String>();
    private boolean ignore = false;

    public Predicate(String type) {
        this(null, type);
    }

    public Predicate(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        if (this.name == null) {
            if (this.parent == null) {
                return null;
            }
            if (this.parent.size() > 0) {
                int index = this.parent.indexOf(this) + 1;
                return index + "_" + this.getType();
            }
            return this.getType();
        }
        return this.name;
    }

    public String getPath() {
        if (this.parent != null) {
            String path = this.parent.getPath();
            if (path != null) {
                return path + "." + this.getName();
            }
            return this.getName();
        }
        if (this.getName() == null) {
            return null;
        }
        return this.getName();
    }

    public String get(String parameterName) {
        return this.params.get(parameterName);
    }

    public String get(String parameterName, String defaultValue) {
        if (this.hasNonEmptyValue(parameterName)) {
            return this.get(parameterName);
        }
        return defaultValue;
    }

    public boolean getBool(String parameterName) {
        if (this.hasNonEmptyValue(parameterName)) {
            String value = this.get(parameterName);
            return "on".equals(value) || "true".equals(value);
        }
        return false;
    }

    public Predicate set(String parameterName, String value) {
        this.params.put(parameterName, value);
        return this;
    }

    public boolean hasNonEmptyValue(String parameterName) {
        String value = this.get(parameterName);
        return value != null && value.length() > 0;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public void setIgnored(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean ignored() {
        return this.ignore;
    }

    public Predicate clone() {
        return this.clone(false);
    }

    public Predicate clone(boolean resetName) {
        try {
            Predicate clone = (Predicate)super.clone();
            clone.parent = null;
            clone.params = new HashMap<String, String>();
            for (String key : this.params.keySet()) {
                clone.params.put(key, this.params.get(key));
            }
            if (resetName) {
                clone.name = null;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.name, (Object)other.name).append(this.params, other.params).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.type).append((Object)this.name).append(this.params).toHashCode();
    }

    protected void setParent(PredicateGroup parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String name = this.getName();
        if (name == null) {
            name = "ROOT";
        }
        buffer.append(name).append("=").append(this.getType()).append(": ");
        HashMap<String, String> allParams = new HashMap<String, String>(this.params);
        Iterator keyIter = allParams.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            buffer.append(key).append("=").append((String)allParams.get(key));
            if (!keyIter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

