/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;

public abstract class XPath {
    public static final String SEARCH_ALL = "//*";
    public static final String NOT = "not";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String ORDER_BY = " order by ";
    public static final String DESC = " descending";
    public static final String OPENING_BRACKET = "(";
    public static final String CLOSING_BRACKET = ")";
    public static final String PREDICATE_OPENING_BRACKET = "[";
    public static final String PREDICATE_CLOSING_BRACKET = "]";
    public static final String JCR_ROOT = "/jcr:root";
    public static final String JCR_LIKE = "jcr:like";
    public static final String JCR_CONTAINS = "jcr:contains";
    public static final String JCR_LIKE_WILDCARD = "%";
    public static final char JCR_LIKE_ANY_WILDCARD = '%';
    public static final char JCR_LIKE_SINGLE_WILDCARD = '_';
    public static final String REP_EXCERPT = "/rep:excerpt(.)";
    public static final String FN_LOWER_CASE = "fn:lower-case";

    public static String getPropertyPath(String property) {
        String name;
        if (property.charAt(0) == '@') {
            property = property.substring(1);
        }
        name = (name = Text.getName(property)).charAt(0) != '@' ? '@' + ISO9075.encode(name) : '@' + ISO9075.encode(name.substring(1));
        String parent = Text.getRelativeParent(property, 1);
        if (parent.length() > 0) {
            return ISO9075.encodePath(parent) + "/" + name;
        }
        return name;
    }

    public static String getStringLiteral(String value) {
        return "'" + value.replaceAll("'", "''") + "'";
    }

    private static int count(String s, char c) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String getFulltextStringLiteral(String value) {
        int doubleQuotes = XPath.count(value, '\"');
        if (doubleQuotes % 2 == 1) {
            int last = value.lastIndexOf(34);
            value = value.substring(0, last) + "\\" + value.substring(last);
        }
        value = Text.escapeIllegalXpathSearchChars(value);
        return "'" + value.replaceAll("'", "''") + "'";
    }

    public static String getEqualsExpression(String property, String value) {
        return XPath.getPropertyPath(property) + " = " + XPath.getStringLiteral(value);
    }

    public static String getUnequalsExpression(String property, String value) {
        return XPath.getPropertyPath(property) + " != " + XPath.getStringLiteral(value);
    }

    public static String getJcrLikeExpression(String property, String value) {
        return "jcr:like(" + XPath.getPropertyPath(property) + ", " + XPath.getStringLiteral(value) + CLOSING_BRACKET;
    }

    public static String getNotExpression(String property) {
        return "not(" + XPath.getPropertyPath(property) + CLOSING_BRACKET;
    }

    public static String getXPathOrderBy(String property, boolean ascending) {
        return XPath.getXPathOrderBy(property, ascending, false);
    }

    public static String getXPathOrderBy(String property, boolean ascending, boolean ignoreCase) {
        if (ignoreCase) {
            return "fn:lower-case(" + XPath.getPropertyPath(property) + CLOSING_BRACKET + (ascending ? "" : DESC);
        }
        return XPath.getPropertyPath(property) + (ascending ? "" : DESC);
    }
}

