/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.AbstractResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoComplete
extends AbstractResultEntity {
    private static final Logger LOG = LoggerFactory.getLogger(AutoComplete.class);
    private static final String ENABLE_NODE = "enabled";
    private static final String CSS_NODE = "css";
    private static final String FORM_NODE = "form-content";
    private static final String JS_NODE = "javascript";
    private String css;
    private String formContent;
    private String js;
    private boolean enabled;

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent nextEvent;
        LOG.debug("Parsing auto-complete tag");
        while (reader.hasNext() && !(nextEvent = ResultParser.getNextEvent(reader)).isEndElement()) {
            String data;
            StartElement element = nextEvent.asStartElement();
            String localPart = element.getName().getLocalPart();
            LOG.debug("Found node {}", (Object)localPart);
            if (ENABLE_NODE.equals(localPart)) {
                data = this.readData(reader);
                this.enabled = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (CSS_NODE.equals(localPart)) {
                this.css = data = this.readData(reader);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (FORM_NODE.equals(localPart)) {
                this.formContent = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (JS_NODE.equals(localPart)) {
                this.js = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
        LOG.debug("Auto-complete node parsed.");
    }

    public String getCss() {
        return this.css;
    }

    public String getFormContent() {
        return this.formContent;
    }

    public String getJs() {
        return this.js;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

