/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.AbstractResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadCrumbItem
extends AbstractResultEntity {
    private static final String LABEL_NODE = "label";
    private static final String VALUE_NODE = "value";
    private static final String LINK_NODE = "link";
    private static final Logger LOG = LoggerFactory.getLogger(BreadCrumbItem.class);
    private String label;
    private String value;
    private String queryString;

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent nextEvent;
        while (reader.hasNext() && !(nextEvent = ResultParser.getNextEvent(reader)).isEndElement()) {
            StartElement element = nextEvent.asStartElement();
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement()) continue;
            String localPart = element.getName().getLocalPart();
            LOG.debug("Found node {}", (Object)localPart);
            if (LABEL_NODE.equals(localPart)) {
                this.label = event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (VALUE_NODE.equals(localPart)) {
                this.value = event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (LINK_NODE.equals(localPart)) {
                this.queryString = event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String getQueryString() {
        return this.queryString;
    }
}

