/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.Field;
import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Result
implements ResultEntity {
    private static final String FIELD_NODE = "field";
    private List<Field> fields = new ArrayList<Field>();

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        while (reader.hasNext()) {
            XMLEvent event;
            while ((event = reader.peek()).isCharacters()) {
                reader.nextEvent();
            }
            if (event.isEndElement()) {
                ResultParser.getNextEvent(reader);
                break;
            }
            StartElement element = event.asStartElement();
            if (element.getName().getLocalPart().equals(FIELD_NODE)) {
                Field field = new Field();
                field.parse(reader);
                this.fields.add(field);
                continue;
            }
            ResultParser.getNextEvent(reader);
            ResultParser.parseUnknownTag(reader);
        }
    }

    public List<Field> getCustomFields() {
        return this.fields;
    }

    public String getTitle() {
        return this.get("title");
    }

    public String getDescription() {
        return this.get("description");
    }

    public String getLink() {
        return this.get("loc");
    }

    public String getTags() {
        return this.get("tags");
    }

    public String get(String key) {
        return this.get(key, "");
    }

    public String get(String key, String defaultValue) {
        String value = this.getField(key);
        return value != null ? value : defaultValue;
    }

    private String getField(String key) {
        for (Field field : this.fields) {
            if (!key.equals(field.getName())) continue;
            return field.getValue();
        }
        return null;
    }
}

