/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.AbstractResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import com.day.cq.searchpromote.xml.result.Suggestion;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Suggestions
extends AbstractResultEntity {
    private static final String AUTO_SEARCH_NODE = "auto-searched";
    private static final String SUGGESTION_LOW_RESULT_NODE = "suggestions-low-results";
    private static final String ORIG_QUERY_NODE = "orig-query";
    private static final String ITEM_NODE = "suggestion-item";
    private boolean autoSearched;
    private boolean suggestionLowResult;
    private String origQuery;
    private List<Suggestion> items = new ArrayList<Suggestion>();

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent event;
        while (reader.hasNext() && !(event = ResultParser.getNextEvent(reader)).isEndElement()) {
            String data;
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            if (AUTO_SEARCH_NODE.equals(localPart)) {
                data = this.readData(reader);
                this.autoSearched = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (SUGGESTION_LOW_RESULT_NODE.equals(localPart)) {
                data = this.readData(reader);
                this.suggestionLowResult = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (ORIG_QUERY_NODE.equals(localPart)) {
                this.origQuery = data = this.readData(reader);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (ITEM_NODE.equals(localPart)) {
                Suggestion item = new Suggestion();
                item.parse(reader);
                this.items.add(item);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public boolean isAutoSearched() {
        return this.autoSearched;
    }

    public boolean isSuggestionLowResult() {
        return this.suggestionLowResult;
    }

    public String getOrigQuery() {
        return this.origQuery;
    }

    public List<Suggestion> getItems() {
        return this.items;
    }
}

