/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.security.util;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.security.Authorizable;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.xss.XSSProtectionService;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableJSONWriter {
    private static final Map<String, String> USER_TO_PROFILE_PROPS;
    private static final Logger log;
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String KEY_HOME_PATH = "home";
    private final ResourceResolver resourceResolver;
    private final Session session;
    private final UserPropertiesManager pMgr;
    private Set<String> outputProps;
    private XSSProtectionService xss;
    private boolean basic;
    private int membersLimit = -1;

    public AuthorizableJSONWriter() {
        throw new UnsupportedOperationException("No longer supported (AuthorizableJSONWriter())");
    }

    public AuthorizableJSONWriter(ProfileManager pMgr, Session session, String[] outputProps, XSSProtectionService xss) {
        throw new UnsupportedOperationException("No longer supported (AuthorizableJSONWriter(ProfileManager, Sesion, String[], XSSProtectionService))");
    }

    public AuthorizableJSONWriter(ResourceResolver resourceResolver, UserPropertiesManager pMgr, String[] outputProps, XSSProtectionService xss) {
        this.resourceResolver = resourceResolver;
        this.session = resourceResolver == null ? null : resourceResolver.adaptTo(Session.class);
        this.pMgr = pMgr;
        this.setOutputProps(outputProps);
        this.xss = xss;
    }

    public void setMembersLimit(int membersLimit) {
        this.membersLimit = membersLimit;
    }

    public void setOutputProps(String[] outputProps) {
        if (outputProps == null) {
            this.outputProps = null;
        } else {
            this.outputProps = new HashSet<String>();
            for (String p : outputProps) {
                this.outputProps.add(p);
            }
        }
    }

    public void setBasic(boolean basic) {
        this.basic = basic;
    }

    public void setXss(XSSProtectionService xss) {
        this.xss = xss;
    }

    public void write(JSONWriter writer, Authorizable authorizable) throws JSONException {
        throw new UnsupportedOperationException("No longer supported (AuthorizableJSONWriter#write(JsonWriter,Authorizable)");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void write(JSONWriter writer, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        writer.object();
        profile = this.getProfile(authorizable);
        if (!this.basic) {
            profileProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : AuthorizableJSONWriter.USER_TO_PROFILE_PROPS.entrySet()) {
                userPropName = entry.getKey();
                profPropName = entry.getValue();
                value = authorizable.getProperty(userPropName);
                if (value == null || value.length <= 0) continue;
                profileProps.put(profPropName, value[0].getString());
            }
            if (profile != null) {
                for (String name : profile.getPropertyNames()) {
                    profileProps.put(name, profile.getProperty(name));
                }
            }
            for (Map.Entry<String, String> entry : profileProps.entrySet()) {
                JSONWriterUtil.write(writer, entry.getKey(), entry.getValue(), JSONWriterUtil.WriteMode.BOTH, this.xss);
            }
            authorizableNode = this.session.getNode(authorizable.getPath());
            try {
                this.write(writer, "jcr:created", authorizableNode.getProperty("jcr:created").getString());
            }
            catch (RepositoryException e) {
                AuthorizableJSONWriter.log.warn("Unable to get {} property from authorizable {}", (Object)"jcr:created", (Object)authorizable.getPath());
            }
            try {
                this.write(writer, "jcr:createdBy", authorizableNode.getProperty("jcr:createdBy").getString());
            }
            catch (RepositoryException e) {
                AuthorizableJSONWriter.log.warn("Unable to get {} property from authorizable {}", (Object)"jcr:createdBy", (Object)authorizable.getPath());
            }
            this.write(writer, "principal", authorizable.getPrincipal().getName());
            this.writeAuthorizables(writer, "memberOf", authorizable.memberOf(), -1, JSONWriterUtil.WriteMode.BOTH);
            if (!authorizable.isGroup()) {
                this.write(writer, "rep:userId", authorizable.getID());
                user = (User)authorizable;
                impersonators = user.getImpersonation().getImpersonators();
                impAuthorizables = new HashSet<org.apache.jackrabbit.api.security.user.Authorizable>();
                userMgr = ((JackrabbitSession)this.session).getUserManager();
                while (impersonators.hasNext()) {
                    p = impersonators.nextPrincipal();
                    a = userMgr.getAuthorizable(p);
                    if (p == null) continue;
                    impAuthorizables.add(a);
                }
                this.writeAuthorizables(writer, "sudoers", impAuthorizables.iterator(), -1, JSONWriterUtil.WriteMode.BOTH);
                try {
                    if (!user.isDisabled()) ** GOTO lbl59
                    this.write(writer, "disabled", user.getDisabledReason());
                }
                catch (RepositoryException e) {
                    throw new JSONException(e);
                }
            } else {
                this.write(writer, "groupName", authorizable.getID());
                memberIter /* !! */  = null;
                memberIter /* !! */  = this.membersLimit == 0 ? Collections.emptyList().iterator() : ((Group)authorizable).getDeclaredMembers();
                this.writeAuthorizables(writer, "members", memberIter /* !! */ , this.membersLimit, JSONWriterUtil.WriteMode.BOTH);
            }
lbl59:
            // 3 sources

            itr = authorizable.getPropertyNames();
            while (itr.hasNext()) {
                name = itr.next();
                if ("id".equals(name) || "name".equals(name) || (vs = authorizable.getProperty(name)) == null || vs.length <= 0) continue;
                this.write(writer, name, vs[0].getString());
            }
            primPhoto = null;
            if (profile != null && (photos = profile.getResources("photos")).hasNext()) {
                primPhoto = photos.next();
            }
            if (primPhoto != null) {
                photoNode = primPhoto.adaptTo(Node.class);
                ext = "png";
                ck = 0L;
                try {
                    content = photoNode.getNode("image").getNode("jcr:content");
                    ck = content.getProperty("jcr:lastModified").getLong();
                    ck = ck / 1000L * 1000L;
                }
                catch (PathNotFoundException e) {
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                this.write(writer, "picturePath", primPhoto.getPath());
                this.write(writer, "pictureExt", ext);
                this.write(writer, "pictureMod", ck);
            } else {
                this.write(writer, "thumbnail", "");
            }
            this.writeModificationDates(writer, authorizable);
            this.writeReplication(writer, authorizable);
        }
        this.write(writer, "type", authorizable.isGroup() != false ? "group" : "user");
        this.write(writer, "id", authorizable.getID());
        JSONWriterUtil.write(writer, "name", AuthorizableJSONWriter.getName(authorizable, profile), JSONWriterUtil.WriteMode.BOTH, this.xss);
        this.write(writer, "home", authorizable.getPath());
        writer.endObject();
    }

    public void write(Writer out, Authorizable authorizable) throws JSONException {
        throw new UnsupportedOperationException("No longer supported (AuthorizableJSONWriter#write(Writer,com.day.cq.security.Authorizable)");
    }

    public void write(Writer out, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        this.write(new JSONWriter(out), authorizable);
    }

    public void writeTable(Writer out, Authorizable authorizable) throws JSONException, RepositoryException {
        throw new UnsupportedOperationException("No longer supported (AuthorizableJSONWriter#write(Writer,com.day.cq.security.Authorizable)");
    }

    public void writeTable(Writer out, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        JSONWriter writer = new JSONWriter(out);
        writer.object();
        AuthorizableJSONWriter.writeColumnHeader(writer, authorizable);
        this.writeRows(writer, authorizable);
        writer.endObject();
    }

    private void write(JSONWriter writer, String key, String value) throws JSONException {
        if (this.includeKey(key)) {
            JSONWriterUtil.write(writer, key, value, null, this.xss);
        }
    }

    private void write(JSONWriter writer, String key, long value) throws JSONException {
        if (this.includeKey(key)) {
            writer.key(key).value(value);
        }
    }

    private void writeRows(JSONWriter json, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        json.key("rows");
        json.array();
        UserProperties profile = this.getProfile(authorizable);
        json.array();
        json.value(authorizable.getID());
        json.array();
        json.value(AuthorizableJSONWriter.getName(authorizable, profile));
        if (!authorizable.isGroup()) {
            json.value(authorizable.getID());
            json.value("***");
        }
        if (profile != null) {
            json.value(profile.getProperty("email"));
        }
        json.endArray();
        json.endArray();
        json.endArray();
    }

    private static void writeColumnHeader(JSONWriter json, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException {
        json.key("columns");
        json.array();
        json.object();
        json.key("id").value("name");
        json.key("text").value("Name");
        json.endObject();
        if (!authorizable.isGroup()) {
            json.object();
            json.key("id").value("rep:userId");
            json.key("text").value("User-ID");
            json.key("inputWidget");
            json.object();
            json.key("type").value("CqTextBox");
            json.endObject();
            json.endObject();
            json.object();
            json.key("id").value("password");
            json.key("text").value("Password");
            json.endObject();
        }
        json.object();
        json.key("id").value("email");
        json.key("text").value("Email");
        json.endObject();
        json.endArray();
    }

    private void writeAuthorizables(JSONWriter writer, String key, Iterator<? extends org.apache.jackrabbit.api.security.user.Authorizable> auths, int limit, JSONWriterUtil.WriteMode writeMode) throws JSONException, RepositoryException {
        int count;
        if (this.includeKey(key)) {
            writer.key(key);
            writer.array();
        }
        for (count = 0; auths.hasNext() && (limit == -1 || count < limit); ++count) {
            org.apache.jackrabbit.api.security.user.Authorizable auth = auths.next();
            if (!this.includeKey(key)) continue;
            writer.object();
            writer.key("id").value(auth.getID());
            JSONWriterUtil.write(writer, "name", AuthorizableJSONWriter.getName(auth, this.getProfile(auth)), writeMode, this.xss);
            writer.key(KEY_HOME_PATH).value(auth.getPath());
            writer.endObject();
        }
        if (this.includeKey(key)) {
            writer.endArray();
        }
        if (this.includeKey(key + "Total")) {
            writer.key(key + "Total").value(count);
        }
    }

    private void writeModificationDates(JSONWriter writer, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        if (this.includeKey("modification")) {
            writer.key("modification").object();
            Calendar lastMod = null;
            if (authorizable.hasProperty("cq:lastModified")) {
                lastMod = authorizable.getProperty("cq:lastModified")[0].getDate();
            }
            if (lastMod != null) {
                writer.key("lastModified").value(lastMod.getTimeInMillis());
                String lastModifiedBy = null;
                if (authorizable.hasProperty("cq:lastModifiedBy")) {
                    lastModifiedBy = authorizable.getProperty("cq:lastModifiedBy")[0].getString();
                }
                JSONWriterUtil.write(writer, "lastModifiedBy", this.getFormattedName(lastModifiedBy), JSONWriterUtil.WriteMode.BOTH, this.xss);
            }
            writer.endObject();
        }
    }

    private void writeReplication(JSONWriter writer, org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws JSONException, RepositoryException {
        Resource authorizableResource;
        if (this.includeKey("replication") && (authorizableResource = this.resourceResolver.getResource(authorizable.getPath())) != null) {
            ReplicationStatus replicationStatus = authorizableResource.adaptTo(ReplicationStatus.class);
            writer.key("replication").object();
            if (replicationStatus != null) {
                int maxQueuePos = -1;
                for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
                    if (e.getQueuePosition() <= maxQueuePos) continue;
                    maxQueuePos = e.getQueuePosition();
                }
                writer.key("numQueued").value(maxQueuePos + 1);
                Calendar last = replicationStatus.getLastPublished();
                if (last != null) {
                    writer.key("published").value(last.getTimeInMillis());
                    JSONWriterUtil.write(writer, "publishedBy", this.getFormattedName(replicationStatus.getLastPublishedBy()), JSONWriterUtil.WriteMode.BOTH, this.xss);
                    if (replicationStatus.getLastReplicationAction() != null) {
                        writer.key("action").value(replicationStatus.getLastReplicationAction().name());
                    }
                }
            }
            writer.endObject();
        }
    }

    private UserProperties getProfile(org.apache.jackrabbit.api.security.user.Authorizable authorizable) throws RepositoryException {
        return this.pMgr != null ? this.pMgr.getUserProperties(authorizable, "profile") : null;
    }

    private String getFormattedName(String id) {
        if (id != null && this.pMgr != null) {
            try {
                String name;
                UserProperties profile = this.pMgr.getUserProperties(id, "profile");
                if (profile != null && (name = profile.getDisplayName()) != null && name.length() > 0) {
                    id = name;
                }
            }
            catch (RepositoryException e) {
                log.debug("Could not access Repository, when trying to access full name of {}: {}", (Object)id, (Object)e);
            }
        }
        return id;
    }

    private static String getName(org.apache.jackrabbit.api.security.user.Authorizable authorizable, UserProperties profile) throws RepositoryException {
        String name = null;
        if (profile != null) {
            name = authorizable.isGroup() ? profile.getProperty("givenName") : profile.getDisplayName();
        }
        return name != null && !name.isEmpty() ? name : authorizable.getID();
    }

    private boolean includeKey(String key) {
        if (this.outputProps == null) {
            return true;
        }
        if (this.outputProps.contains("*")) {
            return !this.outputProps.contains(key);
        }
        return this.outputProps.contains(key);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("rep:description", "aboutMe");
        tmp.put("rep:e-mail", "email");
        tmp.put("cq:first-name", "givenName");
        tmp.put("cq:last-name", "familyName");
        USER_TO_PROFILE_PROPS = tmp;
        log = LoggerFactory.getLogger(AuthorizableJSONWriter.class);
    }
}

