/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.contentsync;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class PathRewriterOptions
extends HashMap<String, RewriteMode> {
    private static final long serialVersionUID = 7042302195945834350L;
    public static final String ATTRIBUTE_PATH_REWRITING_OPTIONS = "pathRewritingOptions";
    public static final String OPTION_REWRITE_LINKS = "links";
    public static final String OPTION_REWRITE_CLIENTLIBS = "clientlibs";
    public static final String OPTION_REWRITE_IMAGES = "images";
    private String relativeParentPath;

    public PathRewriterOptions(RewriteMode links, RewriteMode clientlibs, RewriteMode images) {
        this.setRewriteMode(OPTION_REWRITE_LINKS, links);
        this.setRewriteMode(OPTION_REWRITE_CLIENTLIBS, clientlibs);
        this.setRewriteMode(OPTION_REWRITE_IMAGES, images);
    }

    public boolean isExternal(String option) {
        return this.getRewriteMode(option) == RewriteMode.REWRITE_EXTERNAL;
    }

    public boolean isRelative(String option) {
        return this.getRewriteMode(option) == RewriteMode.REWRITE_RELATIVE;
    }

    public boolean hasRelativeParent() {
        return StringUtils.isNotEmpty((String)this.relativeParentPath);
    }

    public RewriteMode getRewriteMode(String option) {
        return (RewriteMode)((Object)this.get(option));
    }

    public void setRewriteMode(String option, RewriteMode mode) {
        this.put(option, mode);
    }

    public String getRelativeParentPath() {
        return this.relativeParentPath;
    }

    public void setRelativeParentPath(String path) {
        this.relativeParentPath = path;
    }

    public static enum RewriteMode {
        REWRITE_EXTERNAL,
        REWRITE_RELATIVE;

    }
}

