/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.mvt;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.core.mvt.MVTPathBuilder;
import com.day.cq.wcm.core.mvt.PageView;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;

@Deprecated
abstract class MVTEntry
extends Entry {
    protected final String count;
    protected final String rollingWeekCount;
    protected final String rollingMonthCount;
    private final Page page;

    public MVTEntry(String pathPrefix, String countPropName, String rollingWeekCountPropName, String rollingMonthCountPropName, Page page) {
        super(pathPrefix);
        this.count = countPropName;
        this.rollingWeekCount = rollingWeekCountPropName;
        this.rollingMonthCount = rollingMonthCountPropName;
        this.page = page;
    }

    @Override
    protected PathBuilder getPathBuilder() {
        return new MVTPathBuilder(this.page.getPath());
    }

    @Override
    public void write(Node node) throws RepositoryException {
        Node month = node.getParent();
        Node year = month.getParent();
        this.updateViews(node);
        this.updateViews(month);
        this.updateViews(year);
        this.updateCumulativeViews(node, this.rollingWeekCount, 6);
        this.updateCumulativeViews(node, this.rollingMonthCount, 29);
    }

    private void updateViews(Node node) throws RepositoryException {
        long num = 0L;
        if (node.hasProperty(this.count)) {
            num = node.getProperty(this.count).getLong();
        }
        node.setProperty(this.count, ++num);
    }

    private void updateCumulativeViews(Node node, String propertyName, int numDays) throws RepositoryException {
        long num = node.hasProperty(propertyName) ? node.getProperty(propertyName).getLong() : this.getCumulativeCount(node, numDays, this.count);
        node.setProperty(propertyName, ++num);
    }

    private long getCumulativeCount(Node node, int numDays, String propName) throws RepositoryException, ValueFormatException {
        long num = 0L;
        Session session = node.getSession();
        PathBuilder builder = this.getPathBuilder();
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.getTimestamp());
        PageView view = new PageView(this.getPathPrefix(), this.page, "dummy");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numDays; ++i) {
            buffer.setLength(0);
            date.add(5, -1);
            view.setTimestamp(date.getTimeInMillis());
            builder.formatPath(view, buffer);
            String path = buffer.toString();
            try {
                Node n;
                Item item = session.getItem(path);
                if (!item.isNode() || !(n = (Node)item).hasProperty(propName)) continue;
                num += n.getProperty(propName).getLong();
                continue;
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        return num;
    }
}

