/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser;

import com.day.cq.dam.indd.PageBuilder;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTML5Schema;
import com.day.cq.wcm.designimporter.parser.HTMLContent;
import com.day.cq.wcm.designimporter.parser.HTMLContentHandler;
import com.day.cq.wcm.designimporter.parser.ParseResult;
import com.day.cq.wcm.designimporter.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.io.CloseShieldInputStream;
import org.ccil.cowan.tagsoup.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DesignImporterHTMLParser {
    protected DesignImporterContext designImporterContext;
    private String canvasresourceType;
    private HTMLContentHandler handler;
    private Logger logger = LoggerFactory.getLogger(DesignImporterHTMLParser.class);
    private TagHandlerProvider tagHandlerProvider;
    private ParseResult parseResult;

    @Deprecated
    public HTMLContent getBodyHtmlContent() {
        return this.parseResult.getBodyHtmlContent();
    }

    @Deprecated
    public List<PageComponent> getComponents() {
        return this.parseResult.getComponents();
    }

    @Deprecated
    public HTMLContent getHeadHtmlContent() {
        return this.parseResult.getHeadHtmlContent();
    }

    @Deprecated
    public String getLanguage() {
        return this.parseResult.getLanguage();
    }

    private void parse(InputStream stream, ContentHandler handler) throws IOException, SAXException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream = new CloseShieldInputStream(stream);
        InputSource source = new InputSource(stream);
        source.setEncoding(StreamUtil.getEncoding(stream));
        Parser parser = new Parser();
        parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)new HTML5Schema());
        parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
        parser.setContentHandler(handler);
        parser.parse(source);
    }

    @Deprecated
    public void parse(Page page, InputStream stream, PageBuilder pageBuilder) throws DesignImportException {
        this.parse(stream, pageBuilder);
    }

    public ParseResult parse(InputStream stream, PageBuilder pageBuilder) throws DesignImportException {
        block4: {
            this.handler = new HTMLContentHandler();
            this.handler.setTagHandlerProvider(this.tagHandlerProvider);
            this.handler.setDesignImporterContext(this.designImporterContext);
            this.handler.setCanvasResourceType(this.canvasresourceType);
            this.handler.setPageBuilder(pageBuilder);
            try {
                this.parse(stream, this.handler);
            }
            catch (IOException e) {
                this.logger.error("An IO error occured while parsing the input HTML stream", (Throwable)e);
            }
            catch (SAXException e) {
                if (!(e.getException() instanceof DesignImportException)) break block4;
                throw (DesignImportException)e.getException();
            }
        }
        List<PageComponent> generatedComponents = this.handler.getGeneratedComponents();
        if (generatedComponents == null) {
            generatedComponents = new ArrayList<PageComponent>();
        }
        this.parseResult = new ParseResult(generatedComponents, this.handler.getHeadHtmlContent(), this.handler.getBodyHtmlContent(), this.handler.getLanguage());
        return this.parseResult;
    }

    public void setCanvasResourceType(String canvasResourceType) {
        this.canvasresourceType = canvasResourceType;
    }

    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
        this.designImporterContext = designImporterContext;
    }

    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
        this.tagHandlerProvider = tagHandlerProvider;
    }
}

