/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.commons.jcr.JcrUtil;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanvasComponentBuilder {
    private static final String ROOT = "/apps";
    private Session session;
    private String resourceType;
    private StringBuffer scriptContentBuffer = new StringBuffer("<%@include file=\"/libs/foundation/global.jsp\"%>\n<%@ page contentType=\"text/html; charset=utf-8\" %>\n");
    private Logger log = LoggerFactory.getLogger(CanvasComponentBuilder.class);

    public void setSession(Session session) {
        this.session = session;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContentBuffer = new StringBuffer(scriptContent);
    }

    public void appendScriptContent(String scriptContent) {
        this.scriptContentBuffer.append(scriptContent);
    }

    public void prependScriptContent(String scriptContent) {
        this.scriptContentBuffer.insert(0, scriptContent);
    }

    public String getScriptContent() {
        return this.scriptContentBuffer.toString();
    }

    public void build() throws RepositoryException {
        ByteArrayInputStream jspStream;
        Node canvasComponent = JcrUtil.createPath("/apps/" + this.resourceType, "{http://www.jcp.org/jcr/nt/1.0}folder", "cq:Component", this.session, true);
        String scriptName = this.getComponentName() + ".jsp";
        try {
            jspStream = new ByteArrayInputStream(this.getScriptContent().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn("Could not encode content using UTF-8, so using platform's default charset instead", (Throwable)e);
            jspStream = new ByteArrayInputStream(this.getScriptContent().getBytes());
        }
        JcrUtils.putFile(canvasComponent, scriptName, "text/plain", jspStream);
    }

    private String getComponentName() {
        int i = this.resourceType.lastIndexOf(47);
        String componentName = this.resourceType.substring(i + 1, this.resourceType.length());
        return componentName;
    }
}

