/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.designimporter.parser.HTMLContent;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;

public class ClientLibsBuilderImpl {
    private static final String MIMETYPE_CSS = "text/css";
    private static final String MIMETYPE_JS = "application/javascript";
    private static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    private Node designRoot;
    private String folderName;
    private String categoryName;
    private HTMLContent htmlContent;
    private String inlineScriptsFileName;
    private String inlineStylesFileName;
    private ArrayList<String> potentialReferences;

    public void setDesignRoot(Node designRoot) {
        this.designRoot = designRoot;
    }

    public void setFolderName(String folder) {
        this.folderName = folder;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setHtmlContent(HTMLContent htmlContent) {
        this.htmlContent = htmlContent;
    }

    public void setInlineScriptsFileName(String fileName) {
        this.inlineScriptsFileName = fileName;
    }

    public void setInlineStylesFileName(String fileName) {
        this.inlineStylesFileName = fileName;
    }

    public void setPotentialReferences(ArrayList<String> potentialReferences) {
        this.potentialReferences = potentialReferences;
    }

    public void build() throws RepositoryException {
        if (this.htmlContent != null) {
            Node clientLib = JcrUtils.getOrAddNode(this.designRoot, this.folderName, "cq:ClientLibraryFolder");
            List referencedScripts = (List)this.htmlContent.get(HTMLContentType.SCRIPT_INCLUDE);
            ArrayList<String> extractedScriptNames = new ArrayList<String>(referencedScripts);
            this.copyFiles(this.designRoot, extractedScriptNames, clientLib, true, false);
            List referencedStyleSheets = (List)this.htmlContent.get(HTMLContentType.STYLESHEET_INCLUDE);
            ArrayList<String> extractedCssNames = new ArrayList<String>(referencedStyleSheets);
            this.copyFiles(this.designRoot, extractedCssNames, clientLib, true, true);
            String cssContent = (String)this.htmlContent.get(HTMLContentType.STYLES_INLINE);
            cssContent = this.doReferenceAdjustment(cssContent);
            String scriptContent = (String)this.htmlContent.get(HTMLContentType.SCRIPT_INLINE);
            JcrUtils.putFile(clientLib, this.inlineStylesFileName, MIMETYPE_CSS, new ByteArrayInputStream(cssContent.getBytes()));
            JcrUtils.putFile(clientLib, this.inlineScriptsFileName, MIMETYPE_JS, new ByteArrayInputStream(scriptContent.getBytes()));
            extractedScriptNames.add(this.inlineScriptsFileName);
            extractedCssNames.add(this.inlineStylesFileName);
            String jsTxtFileContent = this.convertToLineSeparatedNames(extractedScriptNames);
            String cssTxtFileContent = this.convertToLineSeparatedNames(extractedCssNames);
            JcrUtil.setProperty(clientLib, "categories", new String[]{this.categoryName});
            JcrUtils.putFile(clientLib, "js.txt", MIMETYPE_TEXT_PLAIN, new ByteArrayInputStream(jsTxtFileContent.getBytes()));
            JcrUtils.putFile(clientLib, "css.txt", MIMETYPE_TEXT_PLAIN, new ByteArrayInputStream(cssTxtFileContent.getBytes()));
        }
    }

    private String convertToLineSeparatedNames(List<String> fileNames) {
        String content = "";
        for (String file : fileNames) {
            content = content + file + "\n";
        }
        return content;
    }

    private void copyFiles(Node parentSource, ArrayList<String> fileNames, Node destination, boolean deleteSource, boolean adjust) throws RepositoryException {
        for (String file : fileNames) {
            Node source;
            if (!parentSource.hasNode(file) || (source = parentSource.getNode(file)) == null) continue;
            ArrayList<String> folders = new ArrayList<String>();
            Node parent = source.getParent();
            while (!parent.getPath().equals(parentSource.getPath())) {
                folders.add(parent.getName());
                parent = parent.getParent();
            }
            Node finalDestination = destination;
            for (int i = folders.size() - 1; i >= 0; --i) {
                finalDestination = JcrUtils.getOrAddFolder(finalDestination, (String)folders.get(i));
            }
            Node copy = JcrUtil.copy(source, finalDestination, source.getName());
            if (adjust) {
                this.doReferenceAdjustment(copy);
            }
            if (!deleteSource) continue;
            parent = source.getParent();
            source.remove();
            while (!parent.getNodes().hasNext()) {
                Node p = parent;
                parent = parent.getParent();
                p.remove();
            }
            parent.getParent().getSession().save();
        }
    }

    private void doReferenceAdjustment(Node node) throws RepositoryException {
        if (node == null || !node.hasNode("jcr:content") || !node.hasProperty("jcr:content/jcr:data")) {
            return;
        }
        Node jcrContent = node.getNode("jcr:content");
        String content = jcrContent.getProperty("jcr:data").getString();
        content = this.doReferenceAdjustment(content);
        jcrContent.setProperty("jcr:data", content);
        node.getSession().save();
    }

    private String doReferenceAdjustment(String content) {
        String result = content;
        if (this.potentialReferences != null && result != null) {
            for (String resource : this.potentialReferences) {
                result = result.replaceAll(resource, "../" + resource);
            }
        }
        return result;
    }
}

