/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class DefaultTagHandler
extends AbstractTagHandler {
    private static Set<String> srcNormalizationTags = new HashSet<String>(Arrays.asList("embed", "EMBED", "source", "SOURCE", "video", "VIDEO"));
    private Logger logger = LoggerFactory.getLogger(DefaultTagHandler.class);
    private Attributes atts;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        this.atts = atts;
        this.normalizeSrc(uri, localName, qName, atts);
    }

    private void normalizeSrc(String uri, String localName, String qName, Attributes atts) {
        int index;
        if (srcNormalizationTags.contains(localName) && (index = atts.getIndex("src")) != -1) {
            String type = atts.getType(index);
            try {
                String value = this.designImporterContext.designNode.getPath() + "/" + atts.getValue(index);
                this.atts = new AttributesImpl(atts);
                ((AttributesImpl)this.atts).setAttribute(index, uri, "src", "src", type, value);
            }
            catch (RepositoryException e) {
                this.logger.error("An error occurred while normalizaling the source path of assets for one of the tags in " + srcNormalizationTags.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) {
        String startTag = this.getStartTag(uri, localName, qName, this.atts);
        this.htmlBuffer.insert(0, startTag);
        String endTag = TagUtils.getMatchingEndTag(startTag);
        this.htmlBuffer.append(endTag);
    }

    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {
        return TagUtils.getStartTag(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (this.delegate != null) {
            this.delegate.characters(ch, start, length);
        } else {
            String chars = new String(ch).substring(start, start + length);
            if (chars.length() > 0) {
                this.htmlBuffer.append(StringEscapeUtils.escapeHtml4((String)chars));
            }
        }
    }
}

