/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.util;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.indd.PageComponent;
import java.util.Calendar;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class ComponentUtil {
    public static void writeComponent(PageComponent component, Node parentNode, Session session) throws RepositoryException {
        String resourceType = component.getResourceType();
        String componentName = ComponentUtil.getComponentName(component);
        Node componentNode = JcrUtil.createUniqueNode(parentNode, componentName, "nt:unstructured", session);
        ComponentUtil.addDefaultProperties(componentNode);
        componentNode.setProperty("sling:resourceType", resourceType);
        Set keys = component.getProperties().keySet();
        for (String key : keys) {
            String value = component.getProperties().get(key, "");
            componentNode.setProperty(key, value);
        }
        for (PageComponent childComponent : component.getChildComponents()) {
            ComponentUtil.writeComponent(childComponent, componentNode, session);
        }
    }

    private static void addDefaultProperties(Node componentNode) throws RepositoryException {
        String createdBy = componentNode.getSession().getUserID();
        Calendar now = Calendar.getInstance();
        componentNode.setProperty("jcr:createdBy", createdBy);
        componentNode.setProperty("jcr:created", now);
        componentNode.setProperty("jcr:lastModifiedBy", createdBy);
        componentNode.setProperty("jcr:lastModified", now);
    }

    private static String getComponentName(PageComponent component) {
        if (component.getNameHint() != null) {
            return JcrUtil.createValidName(component.getNameHint());
        }
        return ComponentUtil.getJcrNameFromType(component.getResourceType());
    }

    private static String getJcrNameFromType(String resourceType) {
        String[] paths = resourceType.split("/");
        return JcrUtil.createValidName(paths[paths.length - 1]);
    }
}

