/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.xml.sax.Attributes;

public class TagUtils {
    private static Set<String> emptyTags = new HashSet<String>(Arrays.asList("HR", "BR", "hr", "br"));

    public static String getStartTag(String uri, String localName, String qName, Attributes atts) {
        String startTag = "<" + localName.toLowerCase();
        if (!emptyTags.contains(localName)) {
            String att = "";
            for (int i = 0; i < atts.getLength(); ++i) {
                att = att + " " + atts.getLocalName(i) + "=\"" + StringEscapeUtils.escapeHtml4((String)atts.getValue(i)) + "\"";
            }
            startTag = startTag + att;
            startTag = startTag + ">";
        } else {
            startTag = startTag + " />";
        }
        return startTag;
    }

    public static String getMatchingEndTag(String startTag) {
        if (startTag.matches("<.*/>")) {
            return "";
        }
        Matcher m = Pattern.compile("<([\\S]*).*>").matcher(startTag);
        if (m.find()) {
            return "</" + m.group(1) + ">";
        }
        return "";
    }

    public static String getClientLibIncludeTag(String clientLibCategory) {
        return "<cq:includeClientLib categories=\"" + clientLibCategory + "\" />" + "\n";
    }
}

