/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyMapping;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class AllowedComponentList
extends WCMUsePojo {
    private static final String PLACEHOLDER_COMPONENT_PATH = "wcm/foundation/components/parsys/placeholder";
    private static final String PN_POLICY = "cq:policy";
    private static final String PN_COMPONENTS = "components";
    private static final String COMPONENT_GROUP_PREFIX = "group:";
    public static final String STRUCTURE_JCR_CONTENT = "/structure/jcr:content/";
    public static final String POLICIES_JCR_CONTENT = "/policies/jcr:content/";
    private Collection<Component> components;
    private String[] componentPaths = null;

    @Override
    public void activate() throws Exception {
        ComponentManager componentManager = this.getResourceResolver().adaptTo(ComponentManager.class);
        this.components = componentManager.getComponents();
    }

    public String getTitle() {
        return (this.getComponentPathList().length > 0 ? "Allowed Components" : "No allowed component") + " for " + this.getComponent().getTitle();
    }

    public boolean isApplicable() {
        ValueMap valueMap;
        Template template;
        Page page = this.getCurrentPage();
        if (page != null && (template = page.getTemplate()) != null && template.hasStructureSupport() && (valueMap = this.getResource().getValueMap()) != null && valueMap.containsKey("editable")) {
            return (Boolean)((Object)valueMap.get("editable", Boolean.class));
        }
        return false;
    }

    private String[] getComponentPathList() {
        Resource resource;
        String resourcePath;
        String policyMappingPath;
        if (this.componentPaths != null) {
            return this.componentPaths;
        }
        ResourceResolver resourceResolver = this.getResourceResolver();
        Resource policyMappingResource = resourceResolver.getResource(policyMappingPath = (resourcePath = (resource = this.getResource()).getPath()).replace(STRUCTURE_JCR_CONTENT, POLICIES_JCR_CONTENT));
        if (policyMappingResource != null) {
            ValueMap policyValueMap;
            ContentPolicy policy;
            ContentPolicyMapping contentPolicyMapping;
            ValueMap policyMappingValueMap = policyMappingResource.getValueMap();
            if (!policyMappingValueMap.containsKey(PN_POLICY)) {
                for (Resource parent = policyMappingResource.getParent(); !policyMappingValueMap.containsKey(PN_POLICY) && parent != null; parent = parent.getParent()) {
                    ValueMap parentMappingVM = parent.getValueMap();
                    if (!parentMappingVM.containsKey(PN_POLICY)) {
                        continue;
                    }
                    policyMappingResource = parent;
                    break;
                }
            }
            if ((contentPolicyMapping = policyMappingResource.adaptTo(ContentPolicyMapping.class)) != null && (policy = contentPolicyMapping.getPolicy()) != null && (policyValueMap = policy.getProperties()) != null && policyValueMap.containsKey(PN_COMPONENTS)) {
                this.componentPaths = (String[])policyValueMap.get(PN_COMPONENTS, String[].class);
                return this.componentPaths;
            }
        }
        this.componentPaths = new String[0];
        return this.componentPaths;
    }

    private String getRelativePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String[] searchPaths = resource.getResourceResolver().getSearchPath();
        for (int i = 0; i < searchPaths.length; ++i) {
            String searchPath = searchPaths[i];
            if (!resource.getPath().startsWith(searchPath)) continue;
            String resourcePath = resource.getPath();
            return resourcePath.substring(searchPath.length(), resourcePath.length());
        }
        return null;
    }

    public List getComponents() throws UnsupportedEncodingException {
        ArrayList<ComponentMapping> resources = new ArrayList<ComponentMapping>();
        String[] componentPaths = this.getComponentPathList();
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        if (componentPaths != null && componentPaths.length > 0) {
            String resourcePath = this.getResource().getPath();
            for (int i = 0; i < componentPaths.length; ++i) {
                String compPath = componentPaths[i];
                compPath = compPath != null && compPath.startsWith(COMPONENT_GROUP_PREFIX) ? compPath.substring(COMPONENT_GROUP_PREFIX.length(), compPath.length()) : compPath;
                for (Component component : this.components) {
                    String componentGroup = component.getComponentGroup();
                    if (!component.getPath().endsWith(compPath) && (StringUtils.isEmpty((String)componentGroup) || !componentGroup.equals(compPath))) continue;
                    sortedComponents.add(component);
                }
            }
            Collections.sort(sortedComponents, new ComponentComparator());
            for (Component component : sortedComponents) {
                Resource componentResource = component.adaptTo(Resource.class);
                String key = resourcePath + "/" + this.getRelativePath(componentResource);
                this.getRequest().setAttribute(key, componentResource);
                resources.add(new ComponentMapping(key, PLACEHOLDER_COMPONENT_PATH, "aem-AllowedComponent--component"));
            }
        }
        return resources;
    }

    public String getCssClass() {
        return this.isApplicable() ? "aem-AllowedComponent--list" : "";
    }

    public static class ComponentMapping {
        private String path;
        private String resourceType;
        private String cssClass;

        public ComponentMapping(String path, String resourceType, String cssClass) {
            this.path = path;
            this.resourceType = resourceType;
            this.cssClass = cssClass;
        }

        public String getPath() {
            return this.path;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    private class ComponentComparator
    implements Comparator<Component> {
        private ComponentComparator() {
        }

        @Override
        public int compare(Component comp1, Component comp2) {
            return comp1.getTitle().compareTo(comp2.getTitle());
        }
    }
}

