/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.api.AuthoringUIMode;
import com.day.cq.wcm.api.components.Component;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;

public class Placeholder {
    public static final String DEFAULT_PLACEHOLDER_TOUCH = "cq-placeholder";
    public static final String ATTRIBUTE_EMTPYTEXT = "data-emptytext";

    public static boolean isAuthoringUIModeTouch(ServletRequest slingRequest) {
        return AuthoringUIMode.TOUCH.equals((Object)AuthoringUIMode.fromRequest(slingRequest));
    }

    public static String getDefaultPlaceholder(ServletRequest slingRequest, String title, String defaultPlaceholder, String ... addClasses) {
        String placeholder = defaultPlaceholder;
        if (Placeholder.isAuthoringUIModeTouch(slingRequest)) {
            if (title == null) {
                title = "";
            }
            String cls = DEFAULT_PLACEHOLDER_TOUCH;
            for (String cl : addClasses) {
                if (cl == null) continue;
                cls = cls + " " + cl;
            }
            placeholder = "<div class=\"" + cls + "\" " + ATTRIBUTE_EMTPYTEXT + "=\"" + title + "\">" + "</div>";
        }
        return placeholder;
    }

    public static String getDefaultPlaceholder(ServletRequest slingRequest, Component component, String defaultPlaceholder, String ... addClasses) {
        return Placeholder.getDefaultPlaceholder(slingRequest, Placeholder.getComponentTitle(component), defaultPlaceholder, addClasses);
    }

    public static String getDefaultPlaceholder(ServletRequest slingRequest, Component component, String defaultPlaceholder) {
        return Placeholder.getDefaultPlaceholder(slingRequest, Placeholder.getComponentTitle(component), defaultPlaceholder, new String[0]);
    }

    public static String getComponentTitle(Component component) {
        String title = null;
        if (component != null && StringUtils.isEmpty((CharSequence)(title = component.getProperties().get("./jcr:title").toString()))) {
            title = component.getPath();
        }
        return title;
    }
}

