/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ResponsiveGrid
extends WCMUsePojo {
    private final String DEFAULT_CSS_PREFIX = "aem-Grid";
    private static final int DEFAULT_COLUMNS = 12;
    private static final String BREAKPOINT_VARIANT_NAME_DEFAULT = "default";
    private String cssClassPrefix;
    private int columns;
    private String cssClass;
    private List<Column> paragraphs = new ArrayList<Column>();

    @Override
    public void activate() throws Exception {
        Style currentStyle = this.getCurrentStyle();
        ValueMap properties = this.getProperties();
        HashMap<String, Integer> breakpoints = new HashMap<String, Integer>();
        HashSet<String> missingParagraphBreakpointNames = new HashSet<String>();
        this.cssClassPrefix = currentStyle.get("cssPrefix", "aem-Grid");
        this.cssClass = "aem-Grid";
        Resource responsiveParentCfg = this.getResource().getParent().getChild("cq:responsive");
        Resource responsiveCfg = this.getResource().getChild("cq:responsive");
        boolean hasResponsiveCfgWidth = false;
        if (responsiveCfg != null) {
            Iterator<Resource> resCfgIt = responsiveCfg.listChildren();
            while (resCfgIt.hasNext()) {
                Resource parentBreakpoint;
                Resource resCfg = resCfgIt.next();
                String breakpointName = resCfg.getName();
                ValueMap cfg = resCfg.adaptTo(ValueMap.class);
                int width = cfg.get("width", 0);
                if (responsiveParentCfg != null && (parentBreakpoint = responsiveParentCfg.getChild(breakpointName)) != null) {
                    ValueMap parentCfg = parentBreakpoint.adaptTo(ValueMap.class);
                    int parentWidth = parentCfg.get("width", width);
                    width = width > parentWidth ? parentWidth : width;
                }
                breakpoints.put(breakpointName, width);
                if (width <= 0) continue;
                hasResponsiveCfgWidth = true;
                this.cssClass = this.cssClass + " aem-Grid--" + breakpointName + "--" + width;
            }
        }
        if (!hasResponsiveCfgWidth) {
            int columns = currentStyle.get("columns", 12);
            this.cssClass = this.cssClass + " aem-Grid--" + columns;
        }
        if (!breakpoints.containsKey(BREAKPOINT_VARIANT_NAME_DEFAULT)) {
            int columns = currentStyle.get("columns", 12);
            breakpoints.put(BREAKPOINT_VARIANT_NAME_DEFAULT, columns);
            this.cssClass = this.cssClass + " aem-Grid--default--" + columns;
        }
        Iterator<Resource> paragraphsIt = this.getEffectiveResource().listChildren();
        while (paragraphsIt.hasNext()) {
            Resource child = paragraphsIt.next();
            if ("cq:responsive".equals(child.getName())) continue;
            Column column = child instanceof TemplatedResource ? new Column(((TemplatedResource)child).getResource(), breakpoints) : new Column(child, breakpoints);
            this.paragraphs.add(column);
            missingParagraphBreakpointNames.addAll(column.getMissingBreakpointNames());
        }
        if (!missingParagraphBreakpointNames.isEmpty()) {
            for (String missingParagraphBreakpointName : missingParagraphBreakpointNames) {
                Integer columnCount = (Integer)breakpoints.get(BREAKPOINT_VARIANT_NAME_DEFAULT);
                if (columnCount == null) {
                    columnCount = currentStyle.get("columns", 12);
                }
                this.cssClass = this.cssClass + " aem-Grid--" + missingParagraphBreakpointName + "--" + columnCount;
            }
        }
        this.cssClass = this.cssClass + " " + properties.get("cq:cssClass", "");
    }

    public <T extends Resource> T getEffectiveResource() {
        Resource templatedResource = (Resource)this.getRequest().adaptTo(TemplatedResource.class);
        if (templatedResource == null) {
            return (T)this.getResource();
        }
        return (T)templatedResource;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public List<Column> getParagraphs() {
        return this.paragraphs;
    }

    public class Column {
        private Resource resource;
        private Map<String, Integer> gridBreakpoints;
        private String cssClass;
        private Map<String, Integer> breakpoints;
        private Set<String> columnOnlyBreakpointNames;
        private String columnCssClassPrefix;

        public Column(Resource res) {
            this.resource = res;
            this.columnCssClassPrefix = ResponsiveGrid.this.cssClassPrefix + "Column";
            this.createCssClass();
        }

        public Column(Resource res, Map<String, Integer> gridBreakpoints) {
            this.resource = res;
            this.gridBreakpoints = gridBreakpoints;
            this.columnCssClassPrefix = ResponsiveGrid.this.cssClassPrefix + "Column";
            this.createCssClass();
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getPath() {
            return this.resource.getPath();
        }

        public Set<String> getMissingBreakpointNames() {
            return this.columnOnlyBreakpointNames;
        }

        public Integer getColumnCount(String breakpointName) {
            return this.breakpoints.get(breakpointName);
        }

        private void createCssClass() {
            String cssClass = this.columnCssClassPrefix;
            this.columnOnlyBreakpointNames = new HashSet<String>();
            Component component = WCMUtils.getComponent(this.resource);
            ValueMap componentProperties = null;
            if (component != null) {
                componentProperties = component.getProperties();
            }
            Resource responsiveCfg = this.resource.getChild("cq:responsive");
            this.breakpoints = new HashMap<String, Integer>();
            if (responsiveCfg != null) {
                Iterator<Resource> resCfgIt = responsiveCfg.listChildren();
                while (resCfgIt.hasNext()) {
                    Resource resCfg = resCfgIt.next();
                    String breakpointName = resCfg.getName();
                    ValueMap cfg = resCfg.adaptTo(ValueMap.class);
                    int width = cfg.get("width", 0);
                    String behavior = (String)((Object)cfg.get("behavior", String.class));
                    this.breakpoints.put(breakpointName, width);
                    if (width > 0) {
                        cssClass = cssClass + " " + this.columnCssClassPrefix + "--" + breakpointName + "--" + width;
                    }
                    if (behavior == null) continue;
                    cssClass = cssClass + " " + this.columnCssClassPrefix + "--" + breakpointName + "--" + behavior;
                }
            }
            if (this.gridBreakpoints != null && !this.gridBreakpoints.isEmpty()) {
                ArrayList<String> missingGridBreakpointNames = new ArrayList<String>(this.gridBreakpoints.keySet());
                missingGridBreakpointNames.removeAll(this.breakpoints.keySet());
                for (String missingGridBreakpointName : missingGridBreakpointNames) {
                    Integer width = this.breakpoints.get(ResponsiveGrid.BREAKPOINT_VARIANT_NAME_DEFAULT);
                    Integer gridWidth = this.gridBreakpoints.get(missingGridBreakpointName);
                    if (width == null || gridWidth != null && width > gridWidth) {
                        width = gridWidth;
                    }
                    if (width == null || width > 12) {
                        width = 12;
                    }
                    cssClass = cssClass + " " + this.columnCssClassPrefix + "--" + missingGridBreakpointName + "--" + width;
                    this.breakpoints.put(ResponsiveGrid.BREAKPOINT_VARIANT_NAME_DEFAULT, width);
                }
                ArrayList<String> missingBreakpointNames = new ArrayList<String>(this.breakpoints.keySet());
                missingBreakpointNames.removeAll(this.gridBreakpoints.keySet());
                for (String missingBreakPointName : missingBreakpointNames) {
                    this.columnOnlyBreakpointNames.add(missingBreakPointName);
                }
            } else {
                this.columnOnlyBreakpointNames.addAll(this.breakpoints.keySet());
            }
            if (!this.breakpoints.keySet().contains(ResponsiveGrid.BREAKPOINT_VARIANT_NAME_DEFAULT)) {
                cssClass = cssClass + " " + this.columnCssClassPrefix + "--" + ResponsiveGrid.BREAKPOINT_VARIANT_NAME_DEFAULT + "--" + 12;
            }
            if (componentProperties != null) {
                cssClass = cssClass + " " + componentProperties.get("cq:cssClass", "");
            }
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public ValueMap getProperties() {
            return this.resource.adaptTo(ValueMap.class);
        }
    }
}

