/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.Trends;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.result.ResultPage;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.query.GQL;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Search {
    private final Logger log = LoggerFactory.getLogger(Search.class);
    private static final String QUERY_PARAM_NAME = "q";
    private static final String START_PARAM_NAME = "start";
    private static final String LANGUAGE_FACET_PARAM_NAME = "language";
    private static final String CHARSET_PARAM_NAME = "_charset_";
    private static final String TAG_FACET_PARAM_NAME = "tag";
    private static final String MIME_TYPE_FACET_PARAM_NAME = "mimeType";
    private static final String FROM_FACET_PARAM_NAME = "from";
    private static final String TO_FACET_PARAM_NAME = "to";
    private static final String NODE_TYPE_PARAM_NAME = "nodeType";
    private static final String HTML_EXT = "html";
    private static final String SPELLCHECK_QUERY = "/jcr:root[rep:spellcheck('${query}')]/(rep:spellcheck())";
    private List<String> defaultNodeTypes = new ArrayList<String>(Arrays.asList("cq:Page", "dam:Asset"));
    private final SlingHttpServletRequest request;
    private final SimpleSearch search;
    private final Resource resource;
    private Result result;
    private List<Page> resultPages;
    private String query;
    private boolean tagPredicateSet;

    public Search(SlingHttpServletRequest request) {
        this.request = request;
        this.resource = request.getResource();
        this.search = this.resource.adaptTo(SimpleSearch.class);
        String charset = "ISO-8859-1";
        if (request.getParameter(CHARSET_PARAM_NAME) != null) {
            charset = request.getParameter(CHARSET_PARAM_NAME);
        }
        if (request.getParameter(QUERY_PARAM_NAME) != null) {
            try {
                this.setQuery(new String(request.getParameter(QUERY_PARAM_NAME).getBytes(charset), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (request.getParameter(START_PARAM_NAME) != null) {
            try {
                this.search.setStart(Long.parseLong(request.getParameter(START_PARAM_NAME)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Predicate languagePredicate = new Predicate("languages", LANGUAGE_FACET_PARAM_NAME);
        languagePredicate.set(LANGUAGE_FACET_PARAM_NAME, request.getParameter(LANGUAGE_FACET_PARAM_NAME));
        this.search.addPredicate(languagePredicate);
        Predicate tagPredicate = new Predicate("tags", "tagid");
        tagPredicate.set("property", "jcr:content/cq:tags");
        tagPredicate.set("tagid", request.getParameter(TAG_FACET_PARAM_NAME));
        this.search.addPredicate(tagPredicate);
        this.tagPredicateSet = tagPredicate.get("tagid") != null;
        Predicate mimeTypePredicate = new Predicate("mimeTypes", "property");
        mimeTypePredicate.set("property", "jcr:content/jcr:mimeType");
        mimeTypePredicate.set("value", request.getParameter(MIME_TYPE_FACET_PARAM_NAME));
        this.search.addPredicate(mimeTypePredicate);
        Predicate lastModPredicate = new Predicate("lastModified", "daterange");
        lastModPredicate.set("property", "jcr:content/cq:lastModified");
        lastModPredicate.set("lowerBound", request.getParameter(FROM_FACET_PARAM_NAME));
        lastModPredicate.set("upperBound", request.getParameter(TO_FACET_PARAM_NAME));
        this.search.addPredicate(lastModPredicate);
        Predicate orderByScore = new Predicate("orderByScore", "orderby");
        orderByScore.set("orderby", "@jcr:score");
        orderByScore.set("sort", "desc");
        this.search.addPredicate(orderByScore);
        this.addNodeTypesPredicate();
    }

    public Trends getTrends() {
        return this.search.getTrends();
    }

    public Result getResult() throws RepositoryException {
        if (this.result == null && (this.search.getQuery().length() > 0 || this.tagPredicateSet) && this.search.getResult() != null) {
            this.result = new Result(this.search.getResult());
        }
        return this.result;
    }

    public List<String> getRelatedQueries() throws RepositoryException {
        return this.search.getRelatedQueries();
    }

    public String getQuery() {
        return this.query != null ? this.query : "";
    }

    public void setQuery(String query) {
        this.query = query;
        if (query != null && query.length() > 2 && query.startsWith("\"") && query.endsWith("\"") && !query.substring(1, query.length() - 1).contains("\"")) {
            this.search.setQuery(query);
            return;
        }
        try {
            final StringBuilder sb = new StringBuilder();
            GQL.parse(query, this.request.getResourceResolver().adaptTo(Session.class), new GQL.ParserCallback(){

                @Override
                public void term(String property, String value, boolean optional) throws RepositoryException {
                    sb.append(" ");
                    if (optional) {
                        sb.append("OR ");
                    }
                    if (property.length() > 0) {
                        sb.append(property).append(":");
                    }
                    sb.append(value);
                }
            });
            this.search.setQuery(sb.toString().trim());
        }
        catch (RepositoryException e) {
            this.search.setQuery("");
        }
    }

    @Deprecated
    public String getExcerptPropertyNames() {
        return "";
    }

    @Deprecated
    public void setExcerptPropertyNames(String properties) {
    }

    public long getHitsPerPage() {
        return this.search.getHitsPerPage();
    }

    public void setHitsPerPage(long num) {
        this.search.setHitsPerPage(num);
    }

    public String getSearchIn() {
        return this.search.getSearchIn();
    }

    public void setSearchIn(String searchIn) {
        this.search.setSearchIn(searchIn);
    }

    public String getSearchProperties() {
        return this.search.getSearchProperties();
    }

    public void setSearchProperties(String properties) {
        this.search.setSearchProperties(properties);
    }

    private static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private String getIconPath(String extension) {
        Component c = WCMUtils.getComponent(this.resource);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + extension + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    private void addNodeTypesPredicate() {
        RequestParameter[] nodeTypeParams = this.request.getRequestParameters(NODE_TYPE_PARAM_NAME);
        if (nodeTypeParams != null && nodeTypeParams.length > 0) {
            ArrayList<String> nodeTypes = new ArrayList<String>();
            for (RequestParameter parameter : nodeTypeParams) {
                String type = parameter.getString();
                nodeTypes.add(type);
            }
            this.addNodeTypesPredicate(nodeTypes);
        } else {
            this.addNodeTypesPredicate(this.defaultNodeTypes);
        }
    }

    private void addNodeTypesPredicate(List<String> types) {
        PredicateGroup nodeTypesPredicate = new PredicateGroup("nodeTypes");
        for (String type : types) {
            if (!StringUtils.isNotEmpty((String)type)) continue;
            Predicate predicate = new Predicate("type", "type");
            predicate.set("type", type);
            nodeTypesPredicate.add(predicate);
        }
        nodeTypesPredicate.setAllRequired(false);
        this.search.addPredicate(nodeTypesPredicate);
        this.log.info("Searching with the type(s): {}", (Object)Arrays.toString(types.toArray()));
    }

    public final class Page {
        private final ResultPage rp;

        private Page(ResultPage rp) {
            this.rp = rp;
        }

        public boolean isCurrentPage() {
            return this.rp.isCurrentPage();
        }

        public long getIndex() {
            return this.rp.getIndex();
        }

        public String getURL() {
            String to;
            String from;
            String mimeType;
            String tag;
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append(Search.encodeURL(Search.this.search.getQuery()));
            url.append("&").append(Search.START_PARAM_NAME);
            url.append("=").append(this.rp.getStart());
            String lang = Search.this.request.getParameter(Search.LANGUAGE_FACET_PARAM_NAME);
            if (lang != null) {
                url.append("&").append(Search.LANGUAGE_FACET_PARAM_NAME);
                url.append("=").append(lang);
            }
            if ((tag = Search.this.request.getParameter(Search.TAG_FACET_PARAM_NAME)) != null) {
                url.append("&").append(Search.TAG_FACET_PARAM_NAME);
                url.append("=").append(tag);
            }
            if ((mimeType = Search.this.request.getParameter(Search.MIME_TYPE_FACET_PARAM_NAME)) != null) {
                url.append("&").append(Search.MIME_TYPE_FACET_PARAM_NAME);
                url.append("=").append(mimeType);
            }
            if ((from = Search.this.request.getParameter(Search.FROM_FACET_PARAM_NAME)) != null) {
                url.append("&").append(Search.FROM_FACET_PARAM_NAME);
                url.append("=").append(from);
            }
            if ((to = Search.this.request.getParameter(Search.TO_FACET_PARAM_NAME)) != null) {
                url.append("&").append(Search.TO_FACET_PARAM_NAME);
                url.append("=").append(to);
            }
            return url.toString();
        }
    }

    public final class Hit {
        private final com.day.cq.search.result.Hit hit;

        private Hit(com.day.cq.search.result.Hit hit) {
            this.hit = hit;
        }

        public String getTitle() throws RepositoryException {
            String excerpt = this.hit.getExcerpts().get("jcr:title");
            if (excerpt != null) {
                return excerpt;
            }
            return this.getPageOrAsset().getName();
        }

        public String getExcerpt() throws RepositoryException {
            return this.hit.getExcerpt();
        }

        public String getURL() throws RepositoryException {
            Node n = this.getPageOrAsset();
            String url = Search.this.request.getContextPath() + n.getPath();
            if (this.isPage(n)) {
                url = url + ".html";
            }
            return url;
        }

        public String getSimilarURL() throws RepositoryException {
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append(Search.encodeURL("related:"));
            url.append(Search.encodeURL(this.hit.getPath()));
            return url.toString();
        }

        public String getIcon() throws RepositoryException {
            String url = this.getURL();
            int idx = url.lastIndexOf(46);
            if (idx == -1) {
                return "";
            }
            String ext = url.substring(idx + 1);
            if (ext.equals(Search.HTML_EXT)) {
                return "";
            }
            String path = Search.this.getIconPath(ext);
            if (path == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<img src='");
            sb.append(Search.this.request.getContextPath());
            sb.append(path).append("'/>");
            return sb.toString();
        }

        public String getExtension() throws RepositoryException {
            String url = this.getURL();
            int idx = url.lastIndexOf(46);
            return idx >= 0 ? url.substring(idx + 1) : "";
        }

        public Map getProperties() throws RepositoryException {
            return this.hit.getProperties();
        }

        private boolean isPageOrAsset(Node n) throws RepositoryException {
            return this.isPage(n) || n.isNodeType("dam:Asset");
        }

        private boolean isPage(Node n) throws RepositoryException {
            return n.isNodeType("cq:Page") || n.isNodeType("cq:PseudoPage");
        }

        private Node getPageOrAsset() throws RepositoryException {
            Node n = this.hit.getNode();
            while (!this.isPageOrAsset(n) && n.getName().length() > 0) {
                n = n.getParent();
            }
            return n;
        }
    }

    public final class Result {
        private final SearchResult result;
        private final List<Hit> hits;
        private String spellSuggestion;

        private Result(SearchResult result) {
            this.result = result;
            this.hits = new ArrayList<Hit>();
            for (com.day.cq.search.result.Hit h : result.getHits()) {
                this.hits.add(new Hit(h));
            }
        }

        public List<Page> getResultPages() throws RepositoryException {
            if (Search.this.resultPages == null) {
                Search.this.resultPages = new ArrayList();
                for (ResultPage rp : this.result.getResultPages()) {
                    Search.this.resultPages.add(new Page(rp));
                }
            }
            return Search.this.resultPages;
        }

        public Page getPreviousPage() throws RepositoryException {
            ResultPage previous = this.result.getPreviousPage();
            if (previous != null) {
                return new Page(previous);
            }
            return null;
        }

        public Page getNextPage() throws RepositoryException {
            ResultPage next = this.result.getNextPage();
            if (next != null) {
                return new Page(next);
            }
            return null;
        }

        public String getTrackerScript() {
            StringBuffer sb = new StringBuffer();
            String contextPath = Search.this.request.getContextPath();
            sb.append("<script type='text/javascript'>");
            if (!Search.this.search.getQuery().startsWith("related:")) {
                sb.append("$.post(");
                sb.append("'/bin/statistics/tracker/query',");
                sb.append("{q:'").append(Search.encodeURL(Search.this.search.getQuery())).append("',");
                sb.append("nr:'").append(this.getTotalMatches()).append("',");
                sb.append("et:'").append(this.getExecutionTimeMillis()).append("',");
                sb.append("ct:'").append(System.currentTimeMillis()).append("'});\n");
            }
            sb.append("function trackSelectedResult(obj, position, query) {\n");
            sb.append("  var regExp = /^((\\w+):\\/\\/\\/?)?((\\w+):?(\\w+)?@)?([^\\/\\?:]+):?(\\d+)?(\\/?[^\\?#;\\|]+)?([;\\|])?([^\\?#]+)?\\??([^#]+)?#?(\\w*)/;\n");
            sb.append("  var uri = regExp.exec(obj.href);\n");
            sb.append(" var path= uri[8].substring(" + contextPath.length() + ", uri[8].lastIndexOf('.'));\n");
            sb.append("$.post(");
            sb.append("'/bin/statistics/tracker/result',\n");
            sb.append("{\np:path").append(",\n");
            sb.append("po:position").append(",\n");
            sb.append("q:'").append(Search.encodeURL(Search.this.search.getQuery().toLowerCase())).append("',\n");
            sb.append("rand:Math.random()\n}\n);\n");
            sb.append("}");
            sb.append("</script>");
            return sb.toString();
        }

        public String getSpellcheck() {
            if (this.spellSuggestion == null) {
                try {
                    Value v;
                    Session session = Search.this.request.getResourceResolver().adaptTo(Session.class);
                    RowIterator rows = session.getWorkspace().getQueryManager().createQuery(Search.SPELLCHECK_QUERY.replaceAll("\\$\\{query\\}", Matcher.quoteReplacement(Search.this.getQuery())), "xpath").execute().getRows();
                    String suggestion = null;
                    if (rows.hasNext() && (v = rows.nextRow().getValue("rep:spellcheck()")) != null) {
                        suggestion = v.getString();
                    }
                    if (suggestion == null) {
                        return null;
                    }
                    Search.this.search.setQuery(suggestion);
                    this.spellSuggestion = Search.this.search.getResult().getTotalMatches() > 0L ? suggestion : "";
                }
                catch (RepositoryException e) {
                    this.spellSuggestion = "";
                }
            }
            if (this.spellSuggestion.length() == 0) {
                return null;
            }
            return this.spellSuggestion;
        }

        public long getStartIndex() {
            return this.result.getStartIndex();
        }

        public long getTotalMatches() {
            return this.result.getTotalMatches();
        }

        public String getExecutionTime() {
            return this.result.getExecutionTime();
        }

        public long getExecutionTimeMillis() {
            return this.result.getExecutionTimeMillis();
        }

        public Map<String, Facet> getFacets() throws RepositoryException {
            return this.result.getFacets();
        }

        public List<Hit> getHits() {
            return this.hits;
        }
    }
}

