/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.notification;

import com.day.cq.wcm.notification.Subscription;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.PersistableValueMap;

@Component(componentAbstract=true)
public abstract class AbstractSubscription
implements Subscription {

    public static final class Entry {
        public final String path;
        public final boolean allow;
        public final boolean exact;

        public Entry(String path, boolean exact, boolean allow) {
            this.path = path;
            this.exact = exact;
            this.allow = allow;
        }

        public boolean isAllow() {
            return this.allow;
        }

        public boolean apply(String path, boolean def) {
            boolean match = this.exact ? this.path.equals(path) : this.path.equals(path) || path.startsWith(this.path.equals("/") ? "" : this.path + "/");
            return match ? this.allow : def;
        }

        public String toString() {
            return (this.allow ? "allow" : "deny") + " " + this.path + " " + (this.exact ? "exact" : "tree");
        }
    }

    public static final class Filter {
        public final String[] actions;
        public final Entry[] list;
        final PersistableValueMap configuration;

        public Filter(PersistableValueMap config) {
            String[] paths;
            this.actions = config.get("actions", new String[0]);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (String p : paths = config.get("paths", new String[0])) {
                int p1 = p.indexOf(124);
                int p2 = p.lastIndexOf(124);
                boolean exact = Boolean.valueOf(p.substring(p1 + 1, p2));
                boolean allow = Boolean.valueOf(p.substring(p2 + 1));
                Entry entry = new Entry(p.substring(0, p1), exact, allow);
                entries.add(entry);
            }
            this.list = entries.toArray(new Entry[entries.size()]);
            this.configuration = config;
        }

        public PersistableValueMap getConfiguration() {
            return this.configuration;
        }

        public String[] getActions() {
            return this.actions;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Filter && Arrays.equals(this.list, ((Filter)obj).list);
        }

        public int hashCode() {
            return Arrays.asList(this.list).hashCode();
        }

        public Entry[] getEntries() {
            return this.list;
        }
    }
}

