/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.offline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;

public class OfflineExporter {
    private final HWPFDocument document;
    private final Range range;
    private final Map<String, Style> styles = new HashMap<String, Style>();
    private int maxLevel = 0;

    public static void export(Node node, int maxLevel, OutputStream stream) throws IOException, RepositoryException {
        OfflineExporter exporter = new OfflineExporter(maxLevel);
        if (node.hasProperty("jcr:content/jcr:title")) {
            exporter.document.getSummaryInformation().setTitle(node.getProperty("jcr:content/jcr:title").toString());
        }
        exporter.exportPage(node, 0);
        exporter.document.write(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfflineExporter(int maxLevel) throws IOException {
        InputStream stream = OfflineExporter.class.getResourceAsStream("export.doc");
        try {
            this.document = new HWPFDocument(stream);
            this.range = this.document.getRange();
            this.maxLevel = maxLevel;
            StyleSheet stylesheet = this.document.getStyleSheet();
            for (int i = 0; i < stylesheet.numStyles(); ++i) {
                StyleDescription desc = stylesheet.getStyleDescription(i);
                if (desc == null) continue;
                this.styles.put(desc.getName(), new Style(i, desc));
            }
        }
        finally {
            stream.close();
        }
    }

    private void exportPage(Node page, int level) throws RepositoryException {
        if (page.hasNode("jcr:content")) {
            this.exportContent(page.getNode("jcr:content"), level);
        }
        if (level < this.maxLevel) {
            NodeIterator iterator = page.getNodes();
            while (iterator.hasNext()) {
                Node child = iterator.nextNode();
                if (!child.isNodeType("cq:Page")) continue;
                this.exportPage(child, level + 1);
            }
        }
    }

    private void exportContent(Node node, int level) throws RepositoryException {
        if (node.hasNode("par")) {
            NodeIterator iterator = node.getNode("par").getNodes();
            while (iterator.hasNext()) {
                Node child = iterator.nextNode();
                if (!child.hasProperty("sling:resourceType")) continue;
                String type = child.getProperty("sling:resourceType").getString();
                if (type.equals("foundation/components/title")) {
                    this.exportTitle(child, level);
                    continue;
                }
                if (type.equals("foundation/components/text")) {
                    this.exportText(child);
                    continue;
                }
                if (type.equals("foundation/components/text")) {
                    this.exportText(child);
                    continue;
                }
                if (!type.equals("foundation/components/textimage")) continue;
                this.exportText(child);
            }
        }
    }

    private void exportTitle(Node node, int level) throws RepositoryException {
        Style style;
        if (node.hasProperty("type") && "small".equals(node.getProperty("type").getString())) {
            ++level;
        }
        if ((style = this.styles.get("Heading")) != null && node.hasProperty("jcr:title")) {
            Paragraph paragraph = style.addParagraph();
            paragraph.insertAfter(node.getProperty("jcr:title").getString());
        }
    }

    private void exportText(Node node) throws RepositoryException {
        if (node.hasProperty("text") && this.styles.containsKey("Text body")) {
            Paragraph paragraph = this.styles.get("Text body").addParagraph();
            if (node.hasProperty("textIsRich") && node.getProperty("textIsRich").getBoolean()) {
                paragraph.insertAfter(node.getProperty("text").getString());
            } else {
                paragraph.insertAfter(node.getProperty("text").getString());
            }
        }
    }

    private class Style {
        private int index;
        private StyleDescription description;

        public Style(int index, StyleDescription description) {
            this.index = index;
            this.description = description;
        }

        public Paragraph addParagraph() {
            return OfflineExporter.this.range.insertAfter(this.description.getPAP(), this.index);
        }
    }
}

