/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.siteimporter;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.siteimporter.ProgressTracker;
import com.day.cq.wcm.siteimporter.ResourcesBoard;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImporterContext
implements ProgressTracker {
    private static final Logger log = LoggerFactory.getLogger(ImporterContext.class);
    static final String LANG_DEFAULT = "en";
    static final String USER_AGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.7; en-US; rv:1.9.2.18) Gecko/20110614 Firefox/3.6.18";
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private ResourceResolver resolver;
    private ResourcesBoard board;
    private CloseableHttpClient httpClient;
    private String projectName;
    private String title;
    private URL original;
    private String sitemap;
    private String resourceSuperType;
    private boolean overwrite;
    private String defaultLanguage;
    private final List<ServiceReference> references = new ArrayList<ServiceReference>();
    private final Map<String, Object> services = new HashMap<String, Object>();
    private final List<String> paths = new ArrayList<String>();
    private BundleContext bundleContext;
    private int currentIndent = 0;

    private ImporterContext() {
    }

    public static ImporterContext createContext(SlingHttpServletRequest request, SlingHttpServletResponse response, BundleContext bundleContext) throws MalformedURLException {
        return ImporterContext.createContext(request, response, bundleContext, new ResourcesBoard());
    }

    public static ImporterContext createContext(SlingHttpServletRequest request, SlingHttpServletResponse response, BundleContext bundleContext, ResourcesBoard board) throws MalformedURLException {
        RequestConfig rc = RequestConfig.custom().setCookieSpec("compatibility").setCircularRedirectsAllowed(true).setMaxRedirects(5).build();
        ImporterContext ctx = new ImporterContext();
        ctx.bundleContext = bundleContext;
        ServiceReference sr = bundleContext.getServiceReference(HttpClientBuilderFactory.class.getName());
        HttpClientBuilderFactory httpClientBuilderFactory = null;
        if (sr != null) {
            httpClientBuilderFactory = (HttpClientBuilderFactory)bundleContext.getService(sr);
        }
        ctx.httpClient = httpClientBuilderFactory != null && httpClientBuilderFactory.newBuilder() != null ? httpClientBuilderFactory.newBuilder().setDefaultRequestConfig(rc).setUserAgent(USER_AGENT).build() : HttpClients.custom().build();
        ctx.request = request;
        ctx.response = response;
        ctx.resolver = request.getResourceResolver();
        ctx.board = board;
        ctx.projectName = request.getParameter("projectname").replace(" ", "").toLowerCase();
        ctx.title = request.getParameter("projectname");
        ctx.sitemap = request.getParameter("sitemap");
        ctx.resourceSuperType = request.getParameter("resourceSuperType");
        ctx.overwrite = "true".equals(request.getParameter("overwrite"));
        ctx.original = new URL(request.getParameter("original"));
        return ctx;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getOriginal() {
        return this.original;
    }

    public String getSitemap() {
        return this.sitemap;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public ResourcesBoard getBoard() {
        return this.board;
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            return null;
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void addPath(String path) {
        this.paths.add(path);
    }

    public RequestParameter getThumbnail() {
        return this.request.getRequestParameter("preview");
    }

    public <T> T getService(Class<T> type) {
        ServiceReference ref;
        Object service = this.services.get(type.getName());
        if (service == null && (ref = this.bundleContext.getServiceReference(type.getName())) != null) {
            this.references.add(ref);
            service = this.bundleContext.getService(ref);
            this.services.put(type.getName(), service);
        }
        return (T)service;
    }

    public void dispose() {
        for (ServiceReference reference : this.references) {
            this.bundleContext.ungetService(reference);
        }
        this.references.clear();
        this.services.clear();
    }

    @Override
    public void output(String message) {
        this.output(message, null);
    }

    @Override
    public void output(String message, String css) {
        this.output(message, css, null);
    }

    private void output(String message, String css, Exception e) {
        if (e != null) {
            log.error(message, (Throwable)e);
        } else {
            log.info(message);
        }
        String script = "";
        if ("heading".equals(css)) {
            script = " onclick=\"javascript:toggleDetails(this)\"";
        }
        css = css == null ? "" : " class=\"" + css + "\"";
        try {
            ServiceReference sr = this.bundleContext.getServiceReference(XSSAPI.class.getName());
            XSSAPI xssapi = null;
            if (sr != null) {
                xssapi = (XSSAPI)this.bundleContext.getService(sr);
            }
            this.response.getWriter().print("<li" + script + css + ">" + xssapi.encodeForHTML(message) + "</li>\n");
            this.response.getWriter().write("<script type=\"text/javascript\">");
            this.response.getWriter().write("window.scrollTo(0, 100000);");
            this.response.getWriter().write("</script>");
            this.response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Override
    public void error(String message) {
        this.output(message, "error", null);
    }

    @Override
    public void error(String message, Exception e) {
        this.output(message, "error", e);
    }

    @Override
    public void doIndent() {
        try {
            this.response.getWriter().print("<ol style=\"display:none\">\n");
            this.response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.currentIndent;
    }

    @Override
    public void undoIndent() {
        try {
            this.response.getWriter().print("</ol>\n");
            this.response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        --this.currentIndent;
    }

    @Override
    public void repairIndent() {
        while (this.currentIndent > 0) {
            this.undoIndent();
        }
    }

    @Override
    public void flushBuffer() {
        try {
            this.response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getDefaultLanguage() {
        return StringUtils.defaultIfEmpty((String)this.defaultLanguage, (String)LANG_DEFAULT);
    }
}

