/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.event;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;

public class ExternalProcessPollingEvent
implements Serializable {
    private static final long serialVersionUID = -2349473421221460240L;
    public static final String EVENT_TOPIC = "com/day/cq/workflow/external/polling/event";
    public static final String PROPERTY_POLLING_TIMEOUT = "com.day.cq.workflow.event.polling.timeout";
    public static final String PROPERTY_POLLING_ADVANCE_ON_TIMEOUT = "com.day.cq.workflow.event.polling.advanceOnTimeout";
    public static final String PROPERTY_POLLING_START = "com.day.cq.workflow.event.polling.start";
    public static final String PROPERTY_POLLING_EVENT = "com.day.cq.workflow.event.polling";
    public static final String PROPERTY_POLLING_PROCESS_ID = "com.day.cq.workflow.event.polling.process.id";
    private Map<String, Serializable> workItemMap;
    private Serializable externalProcessId;

    public ExternalProcessPollingEvent(Map<String, Serializable> workItemMap, Serializable externalProcessId) {
        if (workItemMap == null) {
            throw new IllegalArgumentException("work item must not be null.");
        }
        if (externalProcessId == null) {
            throw new IllegalArgumentException("externalProcessId must not be null.");
        }
        this.workItemMap = workItemMap;
        this.externalProcessId = externalProcessId;
    }

    public Map<String, Serializable> getWorkItemMap() {
        return this.workItemMap;
    }

    public Event createPollingEvent(long period, long timeoutSeconds, boolean advanceOnTimeout) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.topic.timed", EVENT_TOPIC);
        ((Dictionary)props).put("event.timed.id", this.workItemMap.get("id"));
        ((Dictionary)props).put("event.timed.period", period);
        ((Dictionary)props).put(PROPERTY_POLLING_EVENT, this);
        ((Dictionary)props).put(PROPERTY_POLLING_TIMEOUT, timeoutSeconds);
        ((Dictionary)props).put(PROPERTY_POLLING_START, Calendar.getInstance().getTime());
        ((Dictionary)props).put(PROPERTY_POLLING_PROCESS_ID, this.externalProcessId);
        ((Dictionary)props).put(PROPERTY_POLLING_ADVANCE_ON_TIMEOUT, advanceOnTimeout);
        return new Event("org/apache/sling/event/timed", props);
    }

    public Event createPollingCancelEvent() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.topic.timed", EVENT_TOPIC);
        ((Dictionary)props).put("event.timed.id", this.workItemMap.get("id"));
        return new Event("org/apache/sling/event/timed", props);
    }
}

