/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.timeout.autoadvance;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Properties(value={@Property(name="service.description", value={"Workflow Auto Advance Process"}), @Property(name="process.label ", value={"Auto Advancer"})})
public class AutoAdvancer
implements WorkflowProcess {
    protected final Logger log = LoggerFactory.getLogger(AutoAdvancer.class);

    @Override
    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
        try {
            boolean advanced = false;
            List<Route> routes = session.getRoutes(item);
            for (Route route : routes) {
                if (!route.hasDefault()) continue;
                String fromTitle = item.getNode().getTitle();
                String toTitle = route.getDestinations().get(0).getTo().getTitle();
                session.complete(item, route);
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
                advanced = true;
            }
            if (!advanced) {
                session.complete(item, routes.get(0));
                String fromTitle = item.getNode().getTitle();
                String toTitle = routes.get(0).getDestinations().get(0).getTo().getTitle();
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
            }
        }
        catch (WorkflowException e) {
            this.log.error("Could not advance workflow.", (Throwable)e);
        }
    }
}

