/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.packaging;

import com.day.crx.packaging.ProxyTracker;
import java.io.IOException;
import java.io.InputStream;

public class TrackingInputStream
extends InputStream {
    private final InputStream base;
    private final long length;
    private long count = 0L;
    private final ProxyTracker tracker;

    public TrackingInputStream(InputStream base, long length, ProxyTracker tracker) {
        this.base = base;
        this.length = length;
        this.tracker = tracker;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int ret = this.base.read(bytes);
        if (ret >= 0) {
            this.count += (long)ret;
            this.tracker.onProgress(this.count, this.length);
        }
        return ret;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int ret = this.base.read(bytes, i, i1);
        if (ret >= 0) {
            this.count += (long)ret;
            this.tracker.onProgress(this.count, this.length);
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = this.base.read();
        if (ret >= 0) {
            this.tracker.onProgress(this.count++, this.length);
        }
        return ret;
    }

    @Override
    public long skip(long l) throws IOException {
        long ret = this.base.skip(l);
        if (ret >= 0L) {
            this.count += ret;
            this.tracker.onProgress(this.count, this.length);
        }
        return ret;
    }
}

