/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics;

import com.day.crx.statistics.Entry;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistics
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Statistics.class);
    private volatile boolean running = true;
    private final Thread writerThread;
    private final Session session;
    private final BlockingQueue<Task> tasks = new LinkedBlockingQueue<Task>();

    public Statistics(Session session) {
        this.session = session;
        this.writerThread = new Thread((Runnable)this, "Statistics write back");
        this.writerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        this.tasks.add(Task.SHUTDOWN);
        try {
            this.writerThread.join(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.writerThread.isAlive()) {
            this.writerThread.interrupt();
            try {
                this.writerThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Session session = this.session;
        synchronized (session) {
            this.session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator runReport(Report report) throws RepositoryException {
        Session session = this.session;
        synchronized (session) {
            this.session.refresh(false);
            return report.getResult(this.session);
        }
    }

    public Iterator runReport(Session session, Report report) throws RepositoryException {
        return report.getResult(session);
    }

    public void addEntry(Entry entry) throws RepositoryException {
        this.addEntryInternal(entry, false);
    }

    public void addEntryAsync(Entry entry) throws RepositoryException {
        this.addEntryInternal(entry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<Task> work = new ArrayList<Task>();
        while (this.running) {
            block23: {
                work.clear();
                try {
                    Task t = this.tasks.take();
                    if (t == Task.SHUTDOWN) {
                        return;
                    }
                    work.add(t);
                    while (this.tasks.peek() != null) {
                        t = this.tasks.take();
                        if (t == Task.SHUTDOWN) {
                            return;
                        }
                        work.add(t);
                    }
                }
                catch (InterruptedException e) {
                    if (this.running) break block23;
                    return;
                }
            }
            RepositoryException exception = null;
            Session session = this.session;
            synchronized (session) {
                try {
                    this.session.refresh(false);
                }
                catch (RepositoryException e) {
                    log.warn("exception while refreshing session", (Throwable)e);
                }
                for (Task task : work) {
                    try {
                        task.performWork();
                    }
                    catch (Throwable e) {
                        if (e instanceof RepositoryException) {
                            exception = (RepositoryException)e;
                            break;
                        }
                        exception = new RepositoryException(e);
                        break;
                    }
                }
                if (exception == null) {
                    try {
                        this.session.save();
                        log.debug("persisted {} entries", (Object)work.size());
                    }
                    catch (Throwable e) {
                        exception = e instanceof RepositoryException ? (RepositoryException)e : new RepositoryException(e);
                    }
                }
            }
            if (exception == null) {
                for (Task task : work) {
                    task.setDone();
                }
                continue;
            }
            try {
                this.session.refresh(false);
            }
            catch (Throwable e) {
                log.warn("exception while refreshing session", e);
            }
            for (Task task : work) {
                task.setException(exception);
            }
        }
    }

    private void addEntryInternal(Entry entry, boolean async) throws RepositoryException {
        if (!this.running) {
            throw new RepositoryException("Statistics stopped");
        }
        Task task = new Task(this.session, entry);
        try {
            this.tasks.put(task);
            if (async) {
                return;
            }
            task.get();
        }
        catch (InterruptedException e) {
            throw new RepositoryException("interrupted while waiting for write back of entry");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw new RepositoryException(e.getCause());
        }
    }
}

