/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public final class LineStyle
implements Paint,
Stroke {
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DOTTED = 1;
    public static final int STYLE_DASHED = 2;
    public static final int STYLE_FANCY = 3;
    private static final Color DEFAULT_COLOR = Color.black;
    public static final LineStyle DEFAULT = new LineStyle(DEFAULT_COLOR);
    private static final float DEFAULT_MARK = 0.0f;
    private static final float DEFAULT_BLANK = 0.0f;
    private static final float DEFAULT_WIDTH = 1.0f;
    private final int style;
    private final float mark;
    private final float blank;
    private final float width;
    private final Paint paint;
    private Stroke lineStroke = null;
    private String stringValue = null;

    public LineStyle(Paint paint) {
        this(paint, Float.NaN, Float.NaN, Float.NaN);
    }

    public LineStyle(Paint paint, float mark, float blank, float width) {
        int style;
        if (paint == null) {
            paint = DEFAULT_COLOR;
        }
        if (Float.isNaN(mark) || mark < 0.0f) {
            mark = 0.0f;
        }
        if (Float.isNaN(blank) || blank < 0.0f) {
            blank = 0.0f;
        }
        if (Float.isNaN(width) || width <= 0.0f) {
            width = 1.0f;
        }
        if (mark == 0.0f) {
            switch ((int)blank) {
                case 1: {
                    style = 1;
                    mark = 1.0f * width;
                    blank = 1.0f * width;
                    break;
                }
                case 2: {
                    style = 2;
                    mark = 3.0f * width;
                    blank = 2.0f * width;
                    break;
                }
                default: {
                    style = 0;
                    mark = 1.0f;
                    blank = 0.0f;
                    break;
                }
            }
        } else if (mark <= 0.0f || blank <= 0.0f) {
            style = 0;
            mark = 1.0f;
            blank = 0.0f;
        } else {
            style = 3;
        }
        this.paint = paint;
        this.style = style;
        this.mark = mark;
        this.blank = blank;
        this.width = width;
    }

    public int getStyle() {
        return this.style;
    }

    public float getMark() {
        return this.mark;
    }

    public float getBlank() {
        return this.blank;
    }

    public float getWidth() {
        return this.width;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.paint.createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    public int getTransparency() {
        return this.paint.getTransparency();
    }

    public Shape createStrokedShape(Shape p) {
        if (this.lineStroke == null) {
            this.lineStroke = this.style == 0 ? new BasicStroke(this.width, 2, 0, 10.0f) : new BasicStroke(this.width, 2, 0, 10.0f, new float[]{this.mark, this.blank}, 0.0f);
        }
        return this.lineStroke.createStrokedShape(p);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("LineStyle: paint=0x");
            buf.append(this.paint);
            buf.append(", width=");
            buf.append(this.width);
            switch (this.style) {
                case 0: {
                    buf.append(", solid");
                    break;
                }
                case 1: {
                    buf.append(", dotted");
                    break;
                }
                case 2: {
                    buf.append(", dashed");
                    break;
                }
                case 3: {
                    buf.append(", fancy: mark=");
                    buf.append(this.mark);
                    buf.append(", blank=");
                    buf.append(this.blank);
                }
            }
            this.stringValue = buf.toString();
        }
        return this.stringValue;
    }
}

