/*
 * Decompiled with CFR 0.152.
 */
package com.day.io.file;

import java.io.IOException;
import java.io.InputStream;

public class SizedInputStream
extends InputStream {
    private final InputStream in;
    private final int max;
    private int pos = 0;
    private int mark = -1;

    public SizedInputStream(InputStream in, int size) {
        this.max = size < 0 ? 0 : size;
        this.in = in;
    }

    private int bytesLeft() {
        return this.max - this.pos;
    }

    public int read() throws IOException {
        if (this.pos == this.max) {
            return -1;
        }
        int result = this.in.read();
        ++this.pos;
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.max) {
            return -1;
        }
        int maxRead = Math.min(len, this.bytesLeft());
        int bytesRead = this.in.read(b, off, maxRead);
        if (bytesRead == -1) {
            return -1;
        }
        this.pos += bytesRead;
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        long skippedBytes = this.in.skip(Math.min(n, (long)this.bytesLeft()));
        this.pos = (int)((long)this.pos + skippedBytes);
        return skippedBytes;
    }

    public int available() throws IOException {
        if (this.pos >= this.max) {
            return 0;
        }
        return this.in.available();
    }

    public String toString() {
        return this.in.toString();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.pos = this.mark;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

