/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.Dumpable;
import com.day.jcr.vault.fs.api.FilterSet;
import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.PathFilter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.api.PathMapping;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.filter.DefaultPathFilter;
import com.day.jcr.vault.fs.spi.ProgressTracker;
import com.day.jcr.vault.util.RejectingEntityResolver;
import com.day.jcr.vault.util.Tree;
import com.day.jcr.vault.util.xml.serialize.OutputFormat;
import com.day.jcr.vault.util.xml.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkspaceFilter
implements Dumpable,
WorkspaceFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkspaceFilter.class);
    private final List<PathFilterSet> filterSets = new LinkedList<PathFilterSet>();
    public static final String ATTR_VERSION = "version";
    public static final double SUPPORTED_VERSION = 1.0;
    protected double version = 1.0;
    private byte[] source;
    private PathFilter globalIgnored;
    private ImportMode importMode;

    public void add(PathFilterSet set) {
        this.filterSets.add(set);
    }

    @Override
    public List<PathFilterSet> getFilterSets() {
        return this.filterSets;
    }

    @Override
    public PathFilterSet getCoveringFilterSet(String path) {
        if (this.isGloballyIgnored(path)) {
            return null;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.covers(path)) continue;
            return set;
        }
        return null;
    }

    @Override
    public ImportMode getImportMode(String path) {
        if (this.importMode != null) {
            return this.importMode;
        }
        PathFilterSet set = this.getCoveringFilterSet(path);
        return set == null ? ImportMode.REPLACE : set.getImportMode();
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    @Override
    public boolean contains(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.contains(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean covers(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.covers(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestor(String path) {
        for (PathFilterSet set : this.filterSets) {
            if (!set.isAncestor(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGloballyIgnored(String path) {
        return this.globalIgnored != null && this.globalIgnored.matches(path);
    }

    @Override
    public WorkspaceFilter translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        DefaultWorkspaceFilter mapped = new DefaultWorkspaceFilter();
        if (this.globalIgnored != null) {
            mapped.setGlobalIgnored(this.globalIgnored.translate(mapping));
        }
        for (PathFilterSet set : this.filterSets) {
            mapped.add(set.translate(mapping));
        }
        return mapped;
    }

    public void load(File file) throws IOException, ConfigurationException {
        this.load(new FileInputStream(file));
    }

    @Override
    public InputStream getSource() {
        if (this.source == null) {
            this.generateSource();
        }
        return new ByteArrayInputStream(this.source);
    }

    @Override
    public String getSourceAsString() {
        if (this.source == null) {
            this.generateSource();
        }
        try {
            return new String(this.source, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void load(InputStream in) throws IOException, ConfigurationException {
        try {
            this.source = IOUtils.toByteArray((InputStream)in);
            in = this.getSource();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in);
            Element doc = document.getDocumentElement();
            if (!doc.getNodeName().equals("workspaceFilter")) {
                throw new ConfigurationException("<workspaceFilter> expected.");
            }
            String v = doc.getAttribute(ATTR_VERSION);
            if (v == null || v.equals("")) {
                v = "1.0";
            }
            this.version = Double.parseDouble(v);
            if (this.version > 1.0) {
                throw new ConfigurationException("version " + this.version + " not supported.");
            }
            this.read(doc);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Configuration file syntax error.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private void read(Element elem) throws ConfigurationException {
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            org.w3c.dom.Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (!child.getNodeName().equals("filter")) {
                throw new ConfigurationException("<filter> expected.");
            }
            PathFilterSet def = this.readDef((Element)child);
            this.filterSets.add(def);
        }
    }

    private PathFilterSet readDef(Element elem) throws ConfigurationException {
        String root = elem.getAttribute("root");
        PathFilterSet def = new PathFilterSet(root == null || root.length() == 0 ? "/" : root);
        String mode = elem.getAttribute("mode");
        if (mode != null && mode.length() > 0) {
            def.setImportMode(ImportMode.valueOf(mode.toUpperCase()));
        }
        NodeList n1 = elem.getChildNodes();
        for (int i = 0; i < n1.getLength(); ++i) {
            org.w3c.dom.Node child = n1.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("include")) {
                def.addInclude(this.readFilter((Element)child));
                continue;
            }
            if (child.getNodeName().equals("exclude")) {
                def.addExclude(this.readFilter((Element)child));
                continue;
            }
            throw new ConfigurationException("either <include> or <exclude> expected.");
        }
        return def;
    }

    private PathFilter readFilter(Element elem) throws ConfigurationException {
        String pattern = elem.getAttribute("pattern");
        if (pattern == null || pattern.equals("")) {
            throw new ConfigurationException("Filter pattern must not be empty");
        }
        return new DefaultPathFilter(pattern);
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        Iterator<PathFilterSet> iter = this.filterSets.iterator();
        while (iter.hasNext()) {
            PathFilterSet set = iter.next();
            ctx.println(!iter.hasNext(), "ItemFilterSet");
            ctx.indent(!iter.hasNext());
            set.dump(ctx, false);
            ctx.outdent();
        }
    }

    private void generateSource() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLSerializer ser = new XMLSerializer(out, new OutputFormat("xml", "UTF-8", true));
            ser.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, ATTR_VERSION, "CDATA", String.valueOf(this.version));
            ser.startElement(null, null, "workspaceFilter", attrs);
            for (PathFilterSet set : this.filterSets) {
                attrs = new AttributesImpl();
                attrs.addAttribute(null, null, "root", "CDATA", set.getRoot());
                if (set.getImportMode() != ImportMode.REPLACE) {
                    attrs.addAttribute(null, null, "mode", "CDATA", set.getImportMode().name().toLowerCase());
                }
                ser.startElement(null, null, "filter", attrs);
                for (FilterSet.Entry entry : set.getEntries()) {
                    PathFilter filter = (PathFilter)entry.getFilter();
                    if (filter instanceof DefaultPathFilter) {
                        attrs = new AttributesImpl();
                        attrs.addAttribute(null, null, "pattern", "CDATA", ((DefaultPathFilter)filter).getPattern());
                        if (entry.isInclude()) {
                            ser.startElement(null, null, "include", attrs);
                            ser.endElement("include");
                            continue;
                        }
                        ser.startElement(null, null, "exclude", attrs);
                        ser.endElement("exclude");
                        continue;
                    }
                    throw new IllegalArgumentException("Can only export default path filters, yet.");
                }
                ser.endElement("filter");
            }
            ser.endElement("workspaceFilter");
            ser.endDocument();
            this.source = out.toByteArray();
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setGlobalIgnored(PathFilter ignored) {
        this.globalIgnored = ignored;
    }

    @Override
    public void dumpCoverage(Node rootNode, ProgressTrackerListener listener) throws RepositoryException {
        ProgressTracker tracker = new ProgressTracker(listener);
        log.debug("Starting coverage dump at / (skipJcrContent=false)");
        this.dumpCoverage(rootNode, tracker, false);
    }

    @Override
    public void dumpCoverage(Session session, ProgressTrackerListener listener, boolean skipJcrContent) throws RepositoryException {
        Node rootNode;
        ProgressTracker tracker = new ProgressTracker(listener);
        Tree<PathFilterSet> tree = new Tree<PathFilterSet>();
        for (PathFilterSet set : this.filterSets) {
            tree.put(set.getRoot(), set);
        }
        String rootPath = tree.getRootPath();
        try {
            rootNode = session.getNode(rootPath);
        }
        catch (RepositoryException e) {
            log.warn("Common ancestor {} not found. Using root node", (Object)rootPath);
            rootNode = session.getRootNode();
            rootPath = "/";
        }
        log.debug("Starting coverage dump at {} (skipJcrContent={})", (Object)rootPath, (Object)skipJcrContent);
        this.dumpCoverage(rootNode, tracker, skipJcrContent);
    }

    private void dumpCoverage(Node node, ProgressTracker tracker, boolean skipJcrContent) throws RepositoryException {
        String path = node.getPath();
        if (skipJcrContent && "jcr:content".equals(Text.getName(path))) {
            return;
        }
        boolean contained = this.contains(path);
        if (contained || this.isAncestor(path)) {
            if (contained) {
                tracker.track("A", path);
            }
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                this.dumpCoverage(iter.nextNode(), tracker, skipJcrContent);
            }
        }
    }
}

