/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util;

import java.util.Comparator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueComparator
implements Comparator<Value> {
    private static final ValueComparator INSTANCE = new ValueComparator();

    private ValueComparator() {
    }

    public static ValueComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Value o1, Value o2) {
        try {
            switch (o1.getType()) {
                case 2: {
                    throw new IllegalArgumentException("sorting of binary values not supported.");
                }
                case 5: {
                    return o1.getDate().compareTo(o2.getDate());
                }
                case 12: {
                    return o1.getDecimal().compareTo(o2.getDecimal());
                }
                case 4: {
                    return Double.valueOf(o1.getDouble()).compareTo(o2.getDouble());
                }
                case 3: {
                    return Long.valueOf(o1.getLong()).compareTo(o2.getLong());
                }
            }
            return o1.getString().compareTo(o2.getString());
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

