/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util.xml.serialize;

import com.day.jcr.vault.util.xml.serialize.OutputFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class Printer {
    protected final OutputFormat _format;
    protected Writer _writer;
    protected StringWriter _dtdWriter;
    protected Writer _docWriter;
    protected IOException _exception;
    private static final int BufferSize = 4096;
    private final char[] _buffer = new char[4096];
    private int _pos = 0;

    public Printer(Writer writer, OutputFormat format) {
        this._writer = writer;
        this._format = format;
        this._exception = null;
        this._dtdWriter = null;
        this._docWriter = null;
        this._pos = 0;
    }

    public IOException getException() {
        return this._exception;
    }

    public void enterDTD() throws IOException {
        if (this._dtdWriter == null) {
            this.flushLine(false);
            this._dtdWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = this._dtdWriter;
        }
    }

    public String leaveDTD() throws IOException {
        if (this._writer == this._dtdWriter) {
            this.flushLine(false);
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    public void printText(String text) throws IOException {
        try {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = text.charAt(i);
                ++this._pos;
            }
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void printText(StringBuffer text) throws IOException {
        try {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = text.charAt(i);
                ++this._pos;
            }
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void printText(char[] chars, int start, int length) throws IOException {
        try {
            while (length-- > 0) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = chars[start];
                ++start;
                ++this._pos;
            }
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void printText(char ch) throws IOException {
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = ch;
            ++this._pos;
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void printSpace() throws IOException {
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = 32;
            ++this._pos;
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void breakLine() throws IOException {
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            String line = this._format.getLineSeparator();
            char[] chL = line.toCharArray();
            for (int i = 0; i < chL.length; ++i) {
                this._buffer[this._pos++] = chL[i];
            }
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
    }

    public void breakLine(boolean preserveSpace) throws IOException {
        this.breakLine();
    }

    public void flushLine(boolean preserveSpace) throws IOException {
        block2: {
            try {
                this._writer.write(this._buffer, 0, this._pos);
            }
            catch (IOException except) {
                if (this._exception != null) break block2;
                this._exception = except;
            }
        }
        this._pos = 0;
    }

    public void flush() throws IOException {
        try {
            this._writer.write(this._buffer, 0, this._pos);
            this._writer.flush();
        }
        catch (IOException except) {
            if (this._exception == null) {
                this._exception = except;
            }
            throw except;
        }
        this._pos = 0;
    }

    public void indent() {
    }

    public void unindent() {
    }

    public int getNextIndent() {
        return 0;
    }

    public void setNextIndent(int indent) {
    }

    public void setThisIndent(int indent) {
    }
}

