/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.util.Finalizer;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizerHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)FinalizerHandler.class);
    private final Stack registered = new Stack();

    public void registerObject(Finalizer object) {
        this.registered.push(object);
    }

    public void unregister(Finalizer object) {
        this.registered.remove(object);
    }

    public void unregisterAll() {
        this.registered.clear();
    }

    public boolean isEmpty() {
        return this.registered.isEmpty();
    }

    public void callFinalizers() {
        while (!this.registered.isEmpty()) {
            Finalizer fin = (Finalizer)this.registered.pop();
            try {
                fin.doFinalize();
            }
            catch (Throwable t) {
                log.error("callFinalizers: Unexpected Exception/Error: {}", (Object)t.toString());
                log.debug("dump", t);
            }
        }
    }
}

