/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;

public final class UInt32ColorModel
extends ComponentColorModel {
    public UInt32ColorModel(ColorSpace cs, boolean hasAlpha, boolean isAlphaPremultiplied) {
        super(cs, hasAlpha, isAlphaPremultiplied, hasAlpha ? 3 : 1, 3);
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        float alpha;
        int numComponents = this.getNumComponents();
        if (normComponents == null) {
            normComponents = new float[numComponents + normOffset];
        }
        int[] ipixel = (int[])pixel;
        int c = 0;
        int nc = normOffset;
        while (c < numComponents) {
            normComponents[nc] = (float)((long)ipixel[c] & 0xFFFFFFFFL) / (float)((1L << this.getComponentSize(c)) - 1L);
            ++c;
            ++nc;
        }
        int numColorComponents = this.getNumColorComponents();
        if (this.hasAlpha() && this.isAlphaPremultiplied() && (alpha = normComponents[numColorComponents + normOffset]) != 0.0f) {
            float invAlpha = 1.0f / alpha;
            int c2 = normOffset;
            while (c2 < numColorComponents + normOffset) {
                int n = c2++;
                normComponents[n] = normComponents[n] * invAlpha;
            }
        }
        return normComponents;
    }
}

