/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

public final class Rational
extends Number
implements Comparable<Rational> {
    static final Rational ZERO = new Rational(0L, 1L);
    static final Rational NaN = new Rational();
    private final long numerator;
    private final long denominator;

    private Rational() {
        this.numerator = 0L;
        this.denominator = 0L;
    }

    public Rational(long pNumber) {
        this(pNumber, 1L);
    }

    public Rational(long pNumerator, long pDenominator) {
        if (pDenominator == 0L) {
            throw new IllegalArgumentException("denominator == 0");
        }
        if (pNumerator == Long.MIN_VALUE || pDenominator == Long.MIN_VALUE) {
            throw new IllegalArgumentException("value == Long.MIN_VALUE");
        }
        long gcd = Rational.gcd(pNumerator, pDenominator);
        long num = pNumerator / gcd;
        long den = pDenominator / gcd;
        this.numerator = pDenominator >= 0L ? num : -num;
        this.denominator = pDenominator >= 0L ? den : -den;
    }

    private static long gcd(long m, long n) {
        if (m < 0L) {
            return Rational.gcd(n, -m);
        }
        return n == 0L ? m : Rational.gcd(n, m % n);
    }

    private static long lcm(long m, long n) {
        if (m < 0L) {
            return Rational.lcm(n, -m);
        }
        return m * (n / Rational.gcd(m, n));
    }

    public long numerator() {
        return this.numerator;
    }

    public long denominator() {
        return this.denominator;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        if (this == NaN) {
            return Double.NaN;
        }
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public int compareTo(Rational pOther) {
        double otherVal;
        double thisVal = this.doubleValue();
        return thisVal < (otherVal = pOther.doubleValue()) ? -1 : (thisVal == otherVal ? 0 : 1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.floatValue());
    }

    public boolean equals(Object pOther) {
        return pOther == this || pOther instanceof Rational && this.compareTo((Rational)pOther) == 0;
    }

    public String toString() {
        if (this == NaN) {
            return "NaN";
        }
        return this.denominator == 1L ? Long.toString(this.numerator) : String.format("%s/%s", this.numerator, this.denominator);
    }

    public Rational times(Rational pOther) {
        if (this.equals(ZERO) || pOther.equals(ZERO)) {
            return ZERO;
        }
        Rational c = new Rational(this.numerator, pOther.denominator);
        Rational d = new Rational(pOther.numerator, this.denominator);
        return new Rational(c.numerator * d.numerator, c.denominator * d.denominator);
    }

    public Rational plus(Rational pOther) {
        if (this.equals(ZERO)) {
            return pOther;
        }
        if (pOther.equals(ZERO)) {
            return this;
        }
        long f = Rational.gcd(this.numerator, pOther.numerator);
        long g = Rational.gcd(this.denominator, pOther.denominator);
        return new Rational((this.numerator / f * (pOther.denominator / g) + pOther.numerator / f * (this.denominator / g)) * f, Rational.lcm(this.denominator, pOther.denominator));
    }

    public Rational negate() {
        return new Rational(-this.numerator, this.denominator);
    }

    public Rational minus(Rational pOther) {
        return this.plus(pOther.negate());
    }

    public Rational reciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public Rational divides(Rational pOther) {
        if (pOther.equals(ZERO)) {
            throw new ArithmeticException("/ by zero");
        }
        return this.times(pOther.reciprocal());
    }
}

