/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;

public final class FileIOUtils {
    private FileIOUtils() {
    }

    public static void writeAsLine(BufferedWriter writer, String str, boolean escape) throws IOException {
        if (escape) {
            writer.write(EscapeUtils.escapeLineBreak(str));
        } else {
            writer.write(str);
        }
        writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeStrings(Iterator<String> iterator, File f, boolean escape) throws IOException {
        BufferedWriter writer = Files.newWriter(f, StandardCharsets.UTF_8);
        boolean threw = true;
        int count = 0;
        try {
            while (iterator.hasNext()) {
                FileIOUtils.writeAsLine(writer, iterator.next(), escape);
                ++count;
            }
            threw = false;
        }
        finally {
            Closeables.close(writer, threw);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readStringsAsSet(InputStream stream, boolean unescape) throws IOException {
        BufferedReader reader = null;
        HashSet<String> set = Sets.newHashSet();
        boolean threw = true;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (unescape) {
                    set.add(EscapeUtils.unescapeLineBreaks(line));
                    continue;
                }
                set.add(line);
            }
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(reader, threw);
            throw throwable;
        }
        Closeables.close(reader, threw);
        return set;
    }

    public static Comparator<String> lineBreakAwareComparator(Comparator<String> delegate) {
        return new TransformingComparator(delegate, new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String input) {
                return EscapeUtils.unescapeLineBreaks(input);
            }
        });
    }

    public static class TransformingComparator
    implements Comparator<String> {
        private Comparator delegate;
        private Function<String, String> func;

        public TransformingComparator(Comparator delegate, Function<String, String> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public int compare(String s1, String s2) {
            return this.delegate.compare(this.func.apply(s1), this.func.apply(s2));
        }
    }
}

