/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.management;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.api.jmx.SessionMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public class RepositoryManager
extends AnnotatedStandardMBean
implements RepositoryManagementMBean {
    private final Whiteboard whiteboard;

    public RepositoryManager(@Nonnull Whiteboard whiteboard) {
        super(RepositoryManagementMBean.class);
        this.whiteboard = Preconditions.checkNotNull(whiteboard);
    }

    public String getName() {
        return "repository manager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ManagementOperation.Status execute(Class<T> serviceType, Function<T, ManagementOperation.Status> operation) {
        Tracker<T> tracker = this.whiteboard.track(serviceType);
        try {
            List<T> services = tracker.getServices();
            if (services.size() == 1) {
                ManagementOperation.Status status = operation.apply(services.get(0));
                return status;
            }
            if (services.isEmpty()) {
                ManagementOperation.Status status = ManagementOperation.Status.unavailable("Cannot perform operation: no service of type " + serviceType.getSimpleName() + " found.");
                return status;
            }
            ManagementOperation.Status status = ManagementOperation.Status.failed("Cannot perform operation: multiple services of type " + serviceType.getSimpleName() + " found.");
            return status;
        }
        finally {
            tracker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Iterable<ManagementOperation.Status> executeAll(Class<T> serviceType, Function<T, ManagementOperation.Status> operation) {
        Tracker<T> tracker = this.whiteboard.track(serviceType);
        ArrayList<ManagementOperation.Status> statuses = Lists.newArrayList();
        try {
            for (T service : tracker.getServices()) {
                statuses.add(operation.apply(service));
            }
            ArrayList<ManagementOperation.Status> arrayList = statuses;
            return arrayList;
        }
        finally {
            tracker.stop();
        }
    }

    @Override
    public CompositeData startBackup() {
        return this.execute(FileStoreBackupRestoreMBean.class, new Function<FileStoreBackupRestoreMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(FileStoreBackupRestoreMBean fileStoreBackupRestoreMBean) {
                return ManagementOperation.Status.fromCompositeData(fileStoreBackupRestoreMBean.startBackup());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData getBackupStatus() {
        return this.execute(FileStoreBackupRestoreMBean.class, new Function<FileStoreBackupRestoreMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(FileStoreBackupRestoreMBean backupService) {
                return ManagementOperation.Status.fromCompositeData(backupService.getBackupStatus());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData startRestore() {
        return this.execute(FileStoreBackupRestoreMBean.class, new Function<FileStoreBackupRestoreMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(FileStoreBackupRestoreMBean backupService) {
                return ManagementOperation.Status.fromCompositeData(backupService.startRestore());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData getRestoreStatus() {
        return this.execute(FileStoreBackupRestoreMBean.class, new Function<FileStoreBackupRestoreMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(FileStoreBackupRestoreMBean backupService) {
                return ManagementOperation.Status.fromCompositeData(backupService.getRestoreStatus());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData startDataStoreGC(final boolean markOnly) {
        return this.execute(BlobGCMBean.class, new Function<BlobGCMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(BlobGCMBean blobGCService) {
                return ManagementOperation.Status.fromCompositeData(blobGCService.startBlobGC(markOnly));
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData getDataStoreGCStatus() {
        return this.execute(BlobGCMBean.class, new Function<BlobGCMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(BlobGCMBean blobGCService) {
                return ManagementOperation.Status.fromCompositeData(blobGCService.getBlobGCStatus());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData startRevisionGC() {
        return this.execute(RevisionGCMBean.class, new Function<RevisionGCMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(RevisionGCMBean revisionGCService) {
                return ManagementOperation.Status.fromCompositeData(revisionGCService.startRevisionGC());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData getRevisionGCStatus() {
        return this.execute(RevisionGCMBean.class, new Function<RevisionGCMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(RevisionGCMBean revisionGCService) {
                return ManagementOperation.Status.fromCompositeData(revisionGCService.getRevisionGCStatus());
            }
        }).toCompositeData();
    }

    @Override
    public String checkpoint(final long lifetime) {
        ManagementOperation.Status status = this.execute(FileStoreBackupRestoreMBean.class, new Function<FileStoreBackupRestoreMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(FileStoreBackupRestoreMBean backupService) {
                String checkpoint = backupService.checkpoint(lifetime);
                return ManagementOperation.Status.succeeded(checkpoint);
            }
        });
        return status.isSuccess() ? status.getMessage() : null;
    }

    @Override
    public CompositeData startPropertyIndexAsyncReindex() {
        return this.execute(PropertyIndexAsyncReindexMBean.class, new Function<PropertyIndexAsyncReindexMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(PropertyIndexAsyncReindexMBean reindexer) {
                return ManagementOperation.Status.fromCompositeData(reindexer.startPropertyIndexAsyncReindex());
            }
        }).toCompositeData();
    }

    @Override
    public CompositeData getPropertyIndexAsyncReindexStatus() {
        return this.execute(PropertyIndexAsyncReindexMBean.class, new Function<PropertyIndexAsyncReindexMBean, ManagementOperation.Status>(){

            @Override
            @Nonnull
            public ManagementOperation.Status apply(PropertyIndexAsyncReindexMBean reindexer) {
                return ManagementOperation.Status.fromCompositeData(reindexer.getPropertyIndexAsyncReindexStatus());
            }
        }).toCompositeData();
    }

    @Override
    public TabularData refreshAllSessions() {
        return ManagementOperation.Status.toTabularData(this.executeAll(SessionMBean.class, new Function<SessionMBean, ManagementOperation.Status>(){

            @Override
            public ManagementOperation.Status apply(SessionMBean sessionMBean) {
                sessionMBean.refresh();
                return ManagementOperation.Status.succeeded("OK");
            }
        }));
    }
}

