/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class AnnotatingConflictHandler
implements ConflictHandler {
    @Override
    public PartialConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_PROPERTY).setProperty(ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_PROPERTY).setProperty(ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_CHANGED_PROPERTY).setProperty(ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_PROPERTY).setProperty(theirs);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_PROPERTY).setProperty(ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_NODE).setChildNode(name, ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_NODE).setChildNode(name, ours);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_NODE), name);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_NODE), name);
        return PartialConflictHandler.Resolution.THEIRS;
    }

    private static NodeBuilder addConflictMarker(NodeBuilder parent) {
        ArrayList<String> mixins = Lists.newArrayList(parent.getNames("jcr:mixinTypes"));
        if (mixins.add("rep:MergeConflict")) {
            parent.setProperty("jcr:mixinTypes", mixins, Type.NAMES);
        }
        NodeBuilder repOurs = parent.child("rep:ours");
        repOurs.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        return repOurs;
    }

    private static NodeBuilder createChild(NodeBuilder parent, ConflictType ct) {
        return parent.child(ct.getName());
    }

    private static void markChild(NodeBuilder parent, String name) {
        parent.child(name);
    }
}

