/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LoggingInfoStream;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.TextExtractionStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.score.ScorerProviderFactory;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.InfoStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak LuceneIndexProvider")
public class LuceneIndexProviderService {
    public static final String REPOSITORY_HOME = "repository.home";
    private LuceneIndexProvider indexProvider;
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private final List<Registration> oakRegs = Lists.newArrayList();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private NodeAggregator nodeAggregator;
    private static final boolean PROP_DISABLED_DEFAULT = false;
    @Property(boolValue={false}, label="Disable this component", description="If true, this component is disabled.")
    private static final String PROP_DISABLED = "disabled";
    @Property(boolValue={false}, label="Enable Debug Logging", description="Enables debug logging in Lucene. After enabling this actual logging can be controlled via changing log level for category 'oak.lucene' to debug")
    private static final String PROP_DEBUG = "debug";
    @Property(boolValue={true}, label="Enable CopyOnRead", description="Enable copying of Lucene index to local file system to improve query performance")
    private static final String PROP_COPY_ON_READ = "enableCopyOnReadSupport";
    @Property(label="Local index storage path", description="Local file system path where Lucene indexes would be copied when CopyOnRead is enabled. If not specified then indexes would be stored under 'index' dir under Repository Home")
    private static final String PROP_LOCAL_INDEX_DIR = "localIndexDir";
    private static final boolean PROP_COPY_ON_WRITE_DEFAULT = true;
    @Property(boolValue={true}, label="Enable CopyOnWrite", description="Enable copying of Lucene index to local file system to improve index writer performance")
    private static final String PROP_COPY_ON_WRITE = "enableCopyOnWriteSupport";
    @Property(boolValue={true}, label="Open index asynchronously", description="Enable opening of indexes in asynchronous mode")
    private static final String PROP_ASYNC_INDEX_OPEN = "enableOpenIndexAsync";
    private static final int PROP_THREAD_POOL_SIZE_DEFAULT = 5;
    @Property(intValue={5}, label="Thread pool size", description="Thread pool size used to perform various asynchronous task in Oak Lucene")
    private static final String PROP_THREAD_POOL_SIZE = "threadPoolSize";
    private static final boolean PROP_PREFETCH_INDEX_FILES_DEFAULT = true;
    @Property(boolValue={true}, label="Prefetch Index Files", description="Prefetch the index files when CopyOnRead is enabled. When enabled all new Lucene index files would be copied locally before the index is made available to QueryEngine")
    private static final String PROP_PREFETCH_INDEX_FILES = "prefetchIndexFiles";
    private static final int PROP_EXTRACTED_TEXT_CACHE_SIZE_DEFAULT = 20;
    @Property(intValue={20}, label="Extracted text cache size (MB)", description="Cache size in MB for caching extracted text for some time. When set to 0 then cache would be disabled")
    private static final String PROP_EXTRACTED_TEXT_CACHE_SIZE = "extractedTextCacheSizeInMB";
    private static final int PROP_EXTRACTED_TEXT_CACHE_EXPIRY_DEFAULT = 300;
    @Property(intValue={300}, label="Extracted text cache expiry (secs)", description="Time in seconds for which the extracted text would be cached in memory")
    private static final String PROP_EXTRACTED_TEXT_CACHE_EXPIRY = "extractedTextCacheExpiryInSecs";
    private static final boolean PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE_DEFAULT = false;
    @Property(boolValue={false}, label="Always use pre-extracted text cache", description="By default pre extracted text cache would only be used for reindex case. If this setting is enabled then it would also be used in normal incremental indexing")
    private static final String PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE = "alwaysUsePreExtractedCache";
    private static final int PROP_BOOLEAN_CLAUSE_LIMIT_DEFAULT = 1024;
    @Property(intValue={1024}, label="Boolean Clause Limit", description="Limit for number of boolean clauses generated for handling of OR query")
    private static final String PROP_BOOLEAN_CLAUSE_LIMIT = "booleanClauseLimit";
    private Whiteboard whiteboard;
    private BackgroundObserver backgroundObserver;
    @Reference
    ScorerProviderFactory scorerFactory;
    @Reference
    private IndexAugmentorFactory augmentorFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PreExtractedTextProvider extractedTextProvider;
    private IndexCopier indexCopier;
    private File indexDir;
    private ExecutorService executorService;
    private int threadPoolSize;
    private ExtractedTextCache extractedTextCache;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) throws NotCompliantMBeanException, IOException {
        boolean disabled = PropertiesUtil.toBoolean(config.get(PROP_DISABLED), false);
        if (disabled) {
            this.log.info("Component disabled by configuration");
            return;
        }
        this.configureBooleanClauseLimit(config);
        this.initializeFactoryClassLoaders(this.getClass().getClassLoader());
        this.whiteboard = new OsgiWhiteboard(bundleContext);
        this.threadPoolSize = PropertiesUtil.toInteger(config.get(PROP_THREAD_POOL_SIZE), 5);
        this.initializeExtractedTextCache(bundleContext, config);
        this.indexProvider = new LuceneIndexProvider(this.createTracker(bundleContext, config), this.scorerFactory, this.augmentorFactory);
        this.initializeLogging(config);
        this.initialize();
        this.regs.add(bundleContext.registerService(QueryIndexProvider.class.getName(), (Object)this.indexProvider, null));
        this.registerObserver(bundleContext, config);
        this.registerIndexEditor(bundleContext, config);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, LuceneIndexMBean.class, new LuceneIndexMBeanImpl(this.indexProvider.getTracker()), "LuceneIndex", "Lucene Index statistics"));
    }

    @Deactivate
    private void deactivate() throws InterruptedException, IOException {
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        if (this.backgroundObserver != null) {
            this.backgroundObserver.close();
        }
        if (this.indexProvider != null) {
            this.indexProvider.close();
            this.indexProvider = null;
        }
        if (this.indexCopier != null) {
            this.indexCopier.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        InfoStream.setDefault(InfoStream.NO_OUTPUT);
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    private void initialize() {
        if (this.indexProvider == null) {
            return;
        }
        if (this.nodeAggregator != null) {
            this.log.debug("Using NodeAggregator {}", this.nodeAggregator.getClass());
        }
        this.indexProvider.setAggregator(this.nodeAggregator);
    }

    private void initializeLogging(Map<String, ?> config) {
        boolean debug = PropertiesUtil.toBoolean(config.get(PROP_DEBUG), false);
        if (debug) {
            InfoStream.setDefault(LoggingInfoStream.INSTANCE);
            this.log.info("Registered LoggingInfoStream with Lucene. Lucene logs can be enabled now via category [{}]", (Object)"oak.lucene");
        }
    }

    private void registerIndexEditor(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        LuceneIndexEditorProvider editorProvider;
        boolean enableCopyOnWrite = PropertiesUtil.toBoolean(config.get(PROP_COPY_ON_WRITE), true);
        if (enableCopyOnWrite) {
            this.initializeIndexCopier(bundleContext, config);
            editorProvider = new LuceneIndexEditorProvider(this.indexCopier, this.extractedTextCache, this.augmentorFactory);
            this.log.info("Enabling CopyOnWrite support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
        } else {
            editorProvider = new LuceneIndexEditorProvider(null, this.extractedTextCache, this.augmentorFactory);
        }
        this.regs.add(bundleContext.registerService(IndexEditorProvider.class.getName(), (Object)editorProvider, null));
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, TextExtractionStatsMBean.class, editorProvider.getExtractedTextCache().getStatsMBean(), "TextExtractionStats", "TextExtraction statistics"));
    }

    private IndexTracker createTracker(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        boolean enableCopyOnRead = PropertiesUtil.toBoolean(config.get(PROP_COPY_ON_READ), true);
        if (enableCopyOnRead) {
            this.initializeIndexCopier(bundleContext, config);
            this.log.info("Enabling CopyOnRead support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
            return new IndexTracker(this.indexCopier);
        }
        return new IndexTracker();
    }

    private void initializeIndexCopier(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        String repoHome;
        if (this.indexCopier != null) {
            return;
        }
        String indexDirPath = PropertiesUtil.toString(config.get(PROP_LOCAL_INDEX_DIR), null);
        boolean prefetchEnabled = PropertiesUtil.toBoolean(config.get(PROP_PREFETCH_INDEX_FILES), true);
        if (Strings.isNullOrEmpty(indexDirPath) && (repoHome = bundleContext.getProperty(REPOSITORY_HOME)) != null) {
            indexDirPath = FilenameUtils.concat((String)repoHome, (String)"index");
        }
        Preconditions.checkNotNull(indexDirPath, "Index directory cannot be determined as neither index directory path [%s] nor repository home [%s] defined", PROP_LOCAL_INDEX_DIR, REPOSITORY_HOME);
        if (prefetchEnabled) {
            this.log.info("Prefetching of index files enabled. Index would be opened after copying all new files locally");
        }
        this.indexDir = new File(indexDirPath);
        this.indexCopier = new IndexCopier(this.getExecutorService(), this.indexDir, prefetchEnabled);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CopyOnReadStatsMBean.class, this.indexCopier, "IndexCopierStats", "IndexCopier support statistics"));
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutor();
        }
        return this.executorService;
    }

    private ExecutorService createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();
            private final Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LuceneIndexProviderService.this.log.warn("Error occurred in asynchronous processing ", e);
                }
            };

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                thread.setUncaughtExceptionHandler(this.handler);
                return thread;
            }

            private String createName() {
                return "oak-lucene-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void registerObserver(BundleContext bundleContext, Map<String, ?> config) {
        boolean enableAsyncIndexOpen = PropertiesUtil.toBoolean(config.get(PROP_ASYNC_INDEX_OPEN), true);
        Closeable observer = this.indexProvider;
        if (enableAsyncIndexOpen) {
            this.backgroundObserver = new BackgroundObserver(this.indexProvider, this.getExecutorService(), 5);
            observer = this.backgroundObserver;
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, this.backgroundObserver.getMBean(), "BackgroundObserverStats", "LuceneIndexConfigObserver queue stats"));
            this.log.info("Registering the LuceneIndexProvider as a BackgroundObserver");
        }
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFactoryClassLoaders(ClassLoader classLoader) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.initializeFactoryClassLoaders0(classLoader);
        }
        catch (Throwable t) {
            this.log.warn("Error occurred while initializing the Lucene Factories", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void initializeFactoryClassLoaders0(ClassLoader classLoader) {
        TokenizerFactory.reloadTokenizers(classLoader);
        CharFilterFactory.reloadCharFilters(classLoader);
        TokenFilterFactory.reloadTokenFilters(classLoader);
    }

    private void initializeExtractedTextCache(BundleContext bundleContext, Map<String, ?> config) {
        CacheStats stats;
        int cacheSizeInMB = PropertiesUtil.toInteger(config.get(PROP_EXTRACTED_TEXT_CACHE_SIZE), 20);
        int cacheExpiryInSecs = PropertiesUtil.toInteger(config.get(PROP_EXTRACTED_TEXT_CACHE_EXPIRY), 300);
        boolean alwaysUsePreExtractedCache = PropertiesUtil.toBoolean(config.get(PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE), false);
        this.extractedTextCache = new ExtractedTextCache((long)cacheSizeInMB * 0x100000L, cacheExpiryInSecs, alwaysUsePreExtractedCache);
        if (this.extractedTextProvider != null) {
            this.registerExtractedTextProvider(this.extractedTextProvider);
        }
        if ((stats = this.extractedTextCache.getCacheStats()) != null) {
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, stats, "CacheStats", stats.getName()));
            this.log.info("Extracted text caching enabled with maxSize {} MB, expiry time {} secs", (Object)cacheSizeInMB, (Object)cacheExpiryInSecs);
        }
    }

    private void registerExtractedTextProvider(PreExtractedTextProvider provider) {
        if (this.extractedTextCache != null) {
            if (provider != null) {
                String usage = this.extractedTextCache.isAlwaysUsePreExtractedCache() ? "always" : "only during reindexing phase";
                this.log.info("Registering PreExtractedTextProvider {} with extracted text cache. It would be used {}", (Object)provider, (Object)usage);
            } else {
                this.log.info("Unregistering PreExtractedTextProvider with extracted text cache");
            }
            this.extractedTextCache.setExtractedTextProvider(provider);
        }
    }

    private void configureBooleanClauseLimit(Map<String, ?> config) {
        int booleanClauseLimit = PropertiesUtil.toInteger(config.get(PROP_BOOLEAN_CLAUSE_LIMIT), 1024);
        if (booleanClauseLimit != BooleanQuery.getMaxClauseCount()) {
            BooleanQuery.setMaxClauseCount(booleanClauseLimit);
            this.log.info("Changed the Max boolean clause limit to {}", (Object)booleanClauseLimit);
        }
    }

    protected void bindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = aggregator;
        this.initialize();
    }

    protected void unbindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = null;
        this.initialize();
    }

    protected void bindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = preExtractedTextProvider;
        this.registerExtractedTextProvider(preExtractedTextProvider);
    }

    protected void unbindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = null;
        this.registerExtractedTextProvider(null);
    }

    protected void bindScorerFactory(ScorerProviderFactory scorerProviderFactory) {
        this.scorerFactory = scorerProviderFactory;
    }

    protected void unbindScorerFactory(ScorerProviderFactory scorerProviderFactory) {
        if (this.scorerFactory == scorerProviderFactory) {
            this.scorerFactory = null;
        }
    }

    protected void bindAugmentorFactory(IndexAugmentorFactory indexAugmentorFactory) {
        this.augmentorFactory = indexAugmentorFactory;
    }

    protected void unbindAugmentorFactory(IndexAugmentorFactory indexAugmentorFactory) {
        if (this.augmentorFactory == indexAugmentorFactory) {
            this.augmentorFactory = null;
        }
    }
}

