/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FilteredSortedSetDocValuesFacetCounts;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.NodeStateFacetsConfig;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.MultiFacets;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacetHelper.class);
    public static final String ATTR_FACET_FIELDS = "oak.facet.fields";

    public static FacetsConfig getFacetsConfig(NodeBuilder definition) {
        return new NodeStateFacetsConfig(definition);
    }

    public static Facets getFacets(IndexSearcher searcher, Query query, TopDocs docs, QueryIndex.IndexPlan plan, boolean secure) throws IOException {
        MultiFacets facets = null;
        List facetFields = (List)plan.getAttribute(ATTR_FACET_FIELDS);
        if (facetFields != null && facetFields.size() > 0) {
            HashMap<String, Facets> facetsMap = new HashMap<String, Facets>();
            for (String facetField : facetFields) {
                FacetsCollector facetsCollector = new FacetsCollector();
                try {
                    DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState(searcher.getIndexReader(), FieldNames.createFacetFieldName(facetField));
                    FacetsCollector.search(searcher, query, 10, facetsCollector);
                    facetsMap.put(facetField, secure ? new FilteredSortedSetDocValuesFacetCounts(state, facetsCollector, plan.getFilter(), docs) : new SortedSetDocValuesFacetCounts(state, facetsCollector));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("facets for {} not yet indexed", (Object)facetField);
                }
            }
            if (facetsMap.size() > 0) {
                facets = new MultiFacets(facetsMap);
            }
        }
        return facets;
    }

    public static String parseFacetField(String columnName) {
        return columnName.substring("rep:facet".length() + 1, columnName.length() - 1);
    }
}

