/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class PropertyIndexLookup {
    public static final double COST_OVERHEAD = 2.0;
    static final int MAX_COST = 100;
    private static final IndexStoreStrategy MIRROR = new ContentMirrorStoreStrategy();
    private static final IndexStoreStrategy UNIQUE = new UniqueEntryStoreStrategy();
    private final NodeState root;

    public PropertyIndexLookup(NodeState root) {
        this.root = root;
    }

    public boolean isIndexed(String propertyName, String path, Filter filter) {
        if (PathUtils.denotesRoot(path)) {
            return this.getIndexNode(this.root, propertyName, filter) != null;
        }
        NodeState node = this.root;
        for (String s : PathUtils.elements(path)) {
            if (this.getIndexNode(node, propertyName, filter) != null) {
                return true;
            }
            node = node.getChildNode(s);
        }
        return false;
    }

    public Iterable<String> query(Filter filter, String propertyName, PropertyValue value) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            throw new IllegalArgumentException("No index for " + propertyName);
        }
        return this.getStrategy(indexMeta).query(filter, propertyName, indexMeta, PropertyIndex.encode(value));
    }

    IndexStoreStrategy getStrategy(NodeState indexMeta) {
        if (indexMeta.getBoolean("unique")) {
            return UNIQUE;
        }
        return MIRROR;
    }

    public double getCost(Filter filter, String propertyName, PropertyValue value) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            return Double.POSITIVE_INFINITY;
        }
        return 2.0 + (double)this.getStrategy(indexMeta).count(filter, this.root, indexMeta, PropertyIndex.encode(value), 100);
    }

    @Nullable
    NodeState getIndexNode(NodeState node, String propertyName, Filter filter) {
        NodeState fallback = null;
        NodeState state = node.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            NodeState indexContent;
            NodeState index = childNodeEntry.getNodeState();
            PropertyState type = index.getProperty("type");
            if (type == null || type.isArray() || !this.getType().equals(type.getValue(Type.STRING)) || !Iterables.contains(index.getNames("propertyNames"), propertyName) || !(indexContent = index.getChildNode(":index")).exists()) continue;
            Set<String> supertypes = PropertyIndexLookup.getSuperTypes(filter);
            if (index.hasProperty("declaringNodeTypes")) {
                if (supertypes == null) continue;
                for (String typeName : index.getNames("declaringNodeTypes")) {
                    if (!supertypes.contains(typeName)) continue;
                    return index;
                }
                continue;
            }
            if (supertypes == null) {
                return index;
            }
            if (fallback != null) continue;
            fallback = index;
        }
        return fallback;
    }

    String getType() {
        return "property";
    }

    @CheckForNull
    private static Set<String> getSuperTypes(Filter filter) {
        if (filter != null && !filter.matchesAllTypes()) {
            return filter.getSupertypes();
        }
        return null;
    }
}

