/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ItemDefinitionTemplate;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NamedTemplate;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeDefinitionTemplateImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.write.PropertyDefinitionTemplateImpl;

class NodeTypeTemplateImpl
extends NamedTemplate
implements NodeTypeTemplate {
    private static final PropertyDefinition[] EMPTY_PROPERTY_DEFINITION_ARRAY = new PropertyDefinition[0];
    private static final NodeDefinition[] EMPTY_NODE_DEFINITION_ARRAY = new NodeDefinition[0];
    protected boolean isMixin;
    protected boolean isOrderable;
    protected boolean isAbstract;
    protected boolean queryable;
    private String primaryItemOakName = null;
    @Nonnull
    private String[] superTypeOakNames = new String[0];
    private List<PropertyDefinitionTemplateImpl> propertyDefinitionTemplates = null;
    private List<NodeDefinitionTemplateImpl> nodeDefinitionTemplates = null;

    NodeTypeTemplateImpl(@Nonnull NameMapper mapper) {
        super(mapper);
    }

    NodeTypeTemplateImpl(@Nonnull NameMapper mapper, @Nonnull NodeTypeDefinition definition) throws ConstraintViolationException {
        super(mapper, definition.getName());
        NodeDefinition[] nds;
        this.setMixin(definition.isMixin());
        this.setOrderableChildNodes(definition.hasOrderableChildNodes());
        this.setAbstract(definition.isAbstract());
        this.setQueryable(definition.isQueryable());
        String primaryItemName = definition.getPrimaryItemName();
        if (primaryItemName != null) {
            this.setPrimaryItemName(primaryItemName);
        }
        this.setDeclaredSuperTypeNames(definition.getDeclaredSupertypeNames());
        PropertyDefinition[] pds = definition.getDeclaredPropertyDefinitions();
        if (pds != null) {
            this.propertyDefinitionTemplates = Lists.newArrayListWithCapacity(pds.length);
            for (PropertyDefinition pd : pds) {
                this.propertyDefinitionTemplates.add(new PropertyDefinitionTemplateImpl(mapper, pd));
            }
        }
        if ((nds = definition.getDeclaredChildNodeDefinitions()) != null) {
            this.nodeDefinitionTemplates = Lists.newArrayListWithCapacity(nds.length);
            for (NodeDefinition nd : nds) {
                this.nodeDefinitionTemplates.add(new NodeDefinitionTemplateImpl(mapper, nd));
            }
        }
    }

    Tree writeTo(@Nonnull Tree parent, boolean allowUpdate) throws RepositoryException {
        String oakName = this.getOakName();
        if (oakName == null) {
            throw new RepositoryException("Cannot register node type: name is missing.");
        }
        Tree type = parent.getChild(oakName);
        if (!type.exists()) {
            type = parent.addChild(oakName);
            type.setProperty("jcr:primaryType", "nt:nodeType", Type.NAME);
        } else if (!allowUpdate) {
            throw new NodeTypeExistsException("Node type " + this.getName() + " already exists");
        }
        type.setProperty("jcr:nodeTypeName", oakName, Type.NAME);
        if (this.superTypeOakNames.length > 0) {
            type.setProperty("jcr:supertypes", Arrays.asList(this.superTypeOakNames), Type.NAMES);
        } else {
            type.removeProperty("jcr:supertypes");
        }
        type.setProperty("jcr:isAbstract", this.isAbstract);
        type.setProperty("jcr:isQueryable", this.queryable);
        type.setProperty("jcr:isMixin", this.isMixin);
        type.setProperty("jcr:hasOrderableChildNodes", this.isOrderable);
        if (this.primaryItemOakName != null) {
            type.setProperty("jcr:primaryItemName", this.primaryItemOakName, Type.NAME);
        } else {
            type.removeProperty("jcr:primaryItemName");
        }
        NodeTypeTemplateImpl.writeItemDefinitions(type, this.propertyDefinitionTemplates, "jcr:propertyDefinition", "nt:propertyDefinition");
        NodeTypeTemplateImpl.writeItemDefinitions(type, this.nodeDefinitionTemplates, "jcr:childNodeDefinition", "nt:childNodeDefinition");
        return type;
    }

    private static void writeItemDefinitions(@Nonnull Tree nodeTypeTree, @CheckForNull List<? extends ItemDefinitionTemplate> itemDefTemplates, @Nonnull String nodeName, @Nonnull String primaryTypeName) throws RepositoryException {
        for (Tree t : Iterables.filter(nodeTypeTree.getChildren(), new SameNamePredicate(nodeName))) {
            t.remove();
        }
        int index = 1;
        if (itemDefTemplates != null) {
            for (ItemDefinitionTemplate itemDefinitionTemplate : itemDefTemplates) {
                String name = NodeTypeTemplateImpl.nodeName(nodeName, index);
                Tree tree = nodeTypeTree.getChild(name);
                if (!tree.exists()) {
                    tree = nodeTypeTree.addChild(name);
                    tree.setProperty("jcr:primaryType", primaryTypeName, Type.NAME);
                }
                itemDefinitionTemplate.writeTo(tree);
                ++index;
            }
        }
    }

    private static String nodeName(String name, int index) {
        return index == 1 ? name : name + '[' + index + ']';
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public void setMixin(boolean mixin) {
        this.isMixin = mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.isOrderable;
    }

    public void setOrderableChildNodes(boolean orderable) {
        this.isOrderable = orderable;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean abstractStatus) {
        this.isAbstract = abstractStatus;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public String getPrimaryItemName() {
        return this.getJcrNameAllowNull(this.primaryItemOakName);
    }

    public void setPrimaryItemName(String jcrName) throws ConstraintViolationException {
        this.primaryItemOakName = this.getOakNameAllowNullOrThrowConstraintViolation(jcrName);
    }

    public String[] getDeclaredSupertypeNames() {
        return this.getJcrNamesAllowNull(this.superTypeOakNames);
    }

    public void setDeclaredSuperTypeNames(String[] jcrNames) throws ConstraintViolationException {
        this.superTypeOakNames = this.getOakNamesOrThrowConstraintViolation(jcrNames);
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.propertyDefinitionTemplates != null) {
            return this.propertyDefinitionTemplates.toArray(EMPTY_PROPERTY_DEFINITION_ARRAY);
        }
        return null;
    }

    public List<? extends PropertyDefinitionTemplate> getPropertyDefinitionTemplates() {
        if (this.propertyDefinitionTemplates == null) {
            this.propertyDefinitionTemplates = Lists.newArrayList();
        }
        return this.propertyDefinitionTemplates;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.nodeDefinitionTemplates != null) {
            return this.nodeDefinitionTemplates.toArray(EMPTY_NODE_DEFINITION_ARRAY);
        }
        return null;
    }

    public List<? extends NodeDefinitionTemplate> getNodeDefinitionTemplates() {
        if (this.nodeDefinitionTemplates == null) {
            this.nodeDefinitionTemplates = Lists.newArrayList();
        }
        return this.nodeDefinitionTemplates;
    }

    public String toString() {
        return String.format("NodeTypeTemplate(%s)", this.getOakName());
    }

    private static final class SameNamePredicate
    implements Predicate<Tree> {
        private final String name;

        private SameNamePredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Tree t) {
            String s = t.getName();
            return s.equals(this.name) || s.startsWith(this.name + "[");
        }
    }
}

