/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PartialCompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.RecordIdMap;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedCompactionMap
implements PartialCompactionMap {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedCompactionMap.class);
    public static final int BYTES_PER_ENTRY = Integer.getInteger("bytes-per-entry", 50);
    private static final int COMPRESS_INTERVAL = Integer.getInteger("compress-interval", 10000000);
    public static final String PERSISTED_COMPACTION_MAP = "PersistedCompactionMap";
    private final TreeMap<UUID, RecordIdMap> recent = Maps.newTreeMap();
    private final SegmentTracker tracker;
    private long recordCount;
    private MapRecord entries;

    PersistedCompactionMap(@Nonnull SegmentTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public boolean wasCompactedTo(@Nonnull RecordId before, @Nonnull RecordId after) {
        return after.equals(this.get(before));
    }

    @Override
    public boolean wasCompacted(@Nonnull UUID uuid) {
        return this.recent.containsKey(uuid) || this.entries != null && this.entries.getEntry(uuid.toString()) != null;
    }

    private static UUID asUUID(@Nonnull SegmentId id) {
        return new UUID(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    @Override
    @CheckForNull
    public RecordId get(@Nonnull RecordId before) {
        short offset;
        UUID uuid = PersistedCompactionMap.asUUID(before.getSegmentId());
        RecordId recordId = PersistedCompactionMap.get(this.recent, uuid, offset = Segment.encode(before.getOffset()));
        if (recordId != null) {
            return recordId;
        }
        return PersistedCompactionMap.get(this.tracker, this.entries, uuid, offset);
    }

    @CheckForNull
    private static RecordId get(@Nonnull Map<UUID, RecordIdMap> map, @Nonnull UUID uuid, short offset) {
        RecordIdMap newSegment = map.get(uuid);
        if (newSegment != null) {
            return newSegment.get(offset);
        }
        return null;
    }

    @CheckForNull
    private static RecordId get(@Nonnull SegmentTracker tracker, @Nullable MapRecord map, @Nonnull UUID uuid, short offset) {
        if (map == null) {
            return null;
        }
        MapEntry newSegmentId = map.getEntry(uuid.toString());
        if (newSegmentId == null) {
            return null;
        }
        MapRecord newSegment = new MapRecord(newSegmentId.getValue());
        MapEntry newRecordId = newSegment.getEntry(String.valueOf(offset));
        if (newRecordId == null) {
            return null;
        }
        return RecordId.fromString(tracker, Segment.readString(newRecordId.getValue()));
    }

    @Override
    public void put(@Nonnull RecordId before, @Nonnull RecordId after) {
        if (this.get(before) != null) {
            throw new IllegalArgumentException();
        }
        UUID uuid = PersistedCompactionMap.asUUID(before.getSegmentId());
        RecordIdMap entry = this.recent.get(uuid);
        if (entry == null) {
            entry = new RecordIdMap();
            this.recent.put(uuid, entry);
        }
        entry.put(Segment.encode(before.getOffset()), after);
        if (this.recent.size() > COMPRESS_INTERVAL) {
            this.compress();
        }
    }

    @Override
    public void remove(@Nonnull Set<UUID> uuids) {
        this.compress(uuids);
    }

    @Override
    public void compress() {
        this.compress(Collections.<UUID>emptySet());
    }

    @Override
    public long getSegmentCount() {
        return this.entries == null ? 0L : (long)this.entries.size();
    }

    @Override
    public long getRecordCount() {
        return this.recordCount;
    }

    @Override
    public boolean isEmpty() {
        return (long)this.recent.size() + this.recordCount == 0L;
    }

    private void compress(@Nonnull Set<UUID> removed) {
        try {
            if (this.recent.isEmpty() && removed.isEmpty()) {
                return;
            }
            SegmentWriter writer = null;
            HashMap<String, RecordId> segmentIdMap = Maps.newHashMap();
            for (Map.Entry<UUID, RecordIdMap> recentEntry : this.recent.entrySet()) {
                MapRecord base;
                UUID uuid = recentEntry.getKey();
                RecordIdMap newSegment = recentEntry.getValue();
                if (removed.contains(uuid)) continue;
                MapEntry baseEntry = this.entries == null ? null : this.entries.getEntry(uuid.toString());
                MapRecord mapRecord = base = baseEntry == null ? null : new MapRecord(baseEntry.getValue());
                if (writer == null) {
                    writer = this.tracker.createSegmentWriter(this.createWid());
                }
                HashMap<String, RecordId> offsetMap = Maps.newHashMap();
                for (int k = 0; k < newSegment.size(); ++k) {
                    offsetMap.put(String.valueOf(newSegment.getKey(k)), writer.writeString(newSegment.getRecordId(k).toString10()));
                }
                RecordId newEntryId = writer.writeMap(base, offsetMap).getRecordId();
                segmentIdMap.put(uuid.toString(), newEntryId);
                this.recordCount += (long)offsetMap.size();
            }
            if (this.entries != null) {
                for (UUID uuid : removed) {
                    MapEntry toRemove = this.entries.getEntry(uuid.toString());
                    if (toRemove == null) continue;
                    segmentIdMap.put(uuid.toString(), null);
                    this.recordCount -= (long)new MapRecord(toRemove.getValue()).size();
                }
            }
            if (!segmentIdMap.isEmpty()) {
                if (writer == null) {
                    writer = this.tracker.createSegmentWriter(this.createWid());
                }
                RecordId previousBaseId = this.entries == null ? null : this.entries.getRecordId();
                this.entries = writer.writeMap(this.entries, segmentIdMap);
                this.entries.getSegment().getSegmentId().pin();
                String mapInfo = "PersistedCompactionMap{id=" + this.entries.getRecordId() + ", baseId=" + previousBaseId + '}';
                writer.writeString(mapInfo);
                writer.flush();
            }
            this.recent.clear();
            if (this.recordCount == 0L) {
                this.entries = null;
            }
        }
        catch (IOException e) {
            LOG.error("Error compression compaction map", (Throwable)e);
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    @Nonnull
    private String createWid() {
        return "cm-" + (this.tracker.getCompactionMap().getGeneration() + 1);
    }

    @Override
    public long getEstimatedWeight() {
        return 0L;
    }
}

