/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.jackrabbit.oak.plugins.segment.file.ReversedLinesFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalReader
implements Closeable,
Iterable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(JournalReader.class);
    private final ReversedLinesFileReader journal;

    public JournalReader(File journalFile) throws IOException {
        this.journal = new ReversedLinesFileReader(journalFile);
    }

    @Override
    public Iterator<String> iterator() {
        return new AbstractIterator<String>(){

            @Override
            protected String computeNext() {
                try {
                    String line = JournalReader.this.journal.readLine();
                    while (line != null) {
                        int space = line.indexOf(32);
                        if (space != -1) {
                            return line.substring(0, space);
                        }
                        line = JournalReader.this.journal.readLine();
                    }
                }
                catch (IOException e) {
                    LOG.error("Error reading journal file", (Throwable)e);
                }
                return (String)this.endOfData();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.journal.close();
    }
}

