/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.oak.plugins.value.ValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryImpl
implements ReferenceBinary {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryImpl.class);
    private final ValueImpl value;

    BinaryImpl(ValueImpl value) {
        this.value = value;
    }

    ValueImpl getBinaryValue() {
        return this.value.getType() == 2 ? this.value : null;
    }

    public InputStream getStream() throws RepositoryException {
        return this.value.getBlob().getNewStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, long position) throws IOException, RepositoryException {
        InputStream stream = this.getStream();
        try {
            if (position != stream.skip(position)) {
                throw new IOException("Can't skip to position " + position);
            }
            int n = stream.read(b);
            return n;
        }
        finally {
            stream.close();
        }
    }

    public long getSize() throws RepositoryException {
        switch (this.value.getType()) {
            case 7: 
            case 8: {
                return this.value.getString().length();
            }
        }
        return this.value.getBlob().length();
    }

    public void dispose() {
    }

    @Override
    @CheckForNull
    public String getReference() {
        try {
            return this.value.getBlob().getReference();
        }
        catch (RepositoryException e) {
            LOG.warn("Error getting binary reference", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ReferenceBinary) {
            return Objects.equal(this.getReference(), ((ReferenceBinary)other).getReference());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getReference());
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.value).toString();
    }
}

