/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CompositeConflictHandler
implements ConflictHandler {
    private final LinkedList<PartialConflictHandler> handlers;

    public CompositeConflictHandler(@Nonnull Iterable<PartialConflictHandler> handlers) {
        this.handlers = Lists.newLinkedList(Preconditions.checkNotNull(handlers));
    }

    public CompositeConflictHandler() {
        this.handlers = Lists.newLinkedList();
    }

    public CompositeConflictHandler addHandler(PartialConflictHandler handler) {
        this.handlers.addFirst(handler);
        return this;
    }

    @Override
    public PartialConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.addExistingProperty(parent, ours, theirs);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_PROPERTY) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.changeDeletedProperty(parent, ours);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.changeChangedProperty(parent, ours, theirs);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.deleteDeletedProperty(parent, ours);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.deleteChangedProperty(parent, theirs);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.addExistingNode(parent, name, ours, theirs);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_NODE) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.changeDeletedNode(parent, name, ours);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_NODE) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.deleteChangedNode(parent, name, theirs);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_NODE) + " conflict");
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name) {
        for (PartialConflictHandler handler : this.handlers) {
            PartialConflictHandler.Resolution resolution = handler.deleteDeletedNode(parent, name);
            if (resolution == null) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_NODE) + " conflict");
    }
}

