/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionGC
implements RevisionGCMBean {
    private static final Logger log = LoggerFactory.getLogger(RevisionGC.class);
    public static final String OP_NAME = "Revision garbage collection";
    private final Runnable gc;
    private final Executor executor;
    private ManagementOperation<String> gcOp = ManagementOperation.done("Revision garbage collection", "");

    public RevisionGC(@Nonnull Runnable gc, @Nonnull Executor executor) {
        this.gc = Preconditions.checkNotNull(gc);
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    @Nonnull
    public CompositeData startRevisionGC() {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    RevisionGC.this.gc.run();
                    return "Revision GC initiated";
                }
            });
            this.executor.execute(this.gcOp);
        }
        return this.getRevisionGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData getRevisionGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }
}

